/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.ApplyNameMapping;
import org.apache.iceberg.avro.AvroCustomOrderSchemaVisitor;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.BuildAvroProjection;
import org.apache.iceberg.avro.HasIds;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.avro.MissingIds;
import org.apache.iceberg.avro.PruneColumns;
import org.apache.iceberg.avro.SchemaToType;
import org.apache.iceberg.avro.TypeToSchema;
import org.apache.iceberg.mapping.MappedField;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class AvroSchemaUtil {
    public static final String ICEBERG_FIELD_NAME_PROP = "iceberg-field-name";
    public static final String FIELD_ID_PROP = "field-id";
    public static final String KEY_ID_PROP = "key-id";
    public static final String VALUE_ID_PROP = "value-id";
    public static final String ELEMENT_ID_PROP = "element-id";
    public static final String ADJUST_TO_UTC_PROP = "adjust-to-utc";
    private static final org.apache.avro.Schema NULL = org.apache.avro.Schema.create((Schema.Type)Schema.Type.NULL);
    private static final Schema.Type MAP = Schema.Type.MAP;
    private static final Schema.Type ARRAY = Schema.Type.ARRAY;
    private static final Schema.Type UNION = Schema.Type.UNION;
    private static final Schema.Type RECORD = Schema.Type.RECORD;

    private AvroSchemaUtil() {
    }

    public static org.apache.avro.Schema convert(Schema schema, String tableName) {
        return AvroSchemaUtil.convert(schema, (Map<Types.StructType, String>)ImmutableMap.of((Object)schema.asStruct(), (Object)tableName));
    }

    public static org.apache.avro.Schema convert(Schema schema, Map<Types.StructType, String> names) {
        return (org.apache.avro.Schema)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new TypeToSchema.WithTypeToName(names));
    }

    public static org.apache.avro.Schema convert(Type type) {
        return AvroSchemaUtil.convert(type, (Map<Types.StructType, String>)ImmutableMap.of());
    }

    public static org.apache.avro.Schema convert(Types.StructType type, String name) {
        return AvroSchemaUtil.convert((Type)type, (Map<Types.StructType, String>)ImmutableMap.of((Object)type, (Object)name));
    }

    public static org.apache.avro.Schema convert(Type type, Map<Types.StructType, String> names) {
        return (org.apache.avro.Schema)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToSchema.WithTypeToName(names));
    }

    public static org.apache.avro.Schema convert(Type type, BiFunction<Integer, Types.StructType, String> namesFunction) {
        return (org.apache.avro.Schema)TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)new TypeToSchema.WithNamesFunction(namesFunction));
    }

    public static Type convert(org.apache.avro.Schema schema) {
        return AvroSchemaVisitor.visit(schema, new SchemaToType(schema));
    }

    public static Schema toIceberg(org.apache.avro.Schema schema) {
        List fields = AvroSchemaUtil.convert(schema).asNestedType().asStructType().fields();
        return new Schema(fields);
    }

    static boolean hasIds(org.apache.avro.Schema schema) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new HasIds());
    }

    static boolean missingIds(org.apache.avro.Schema schema) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new MissingIds());
    }

    public static Map<Type, org.apache.avro.Schema> convertTypes(Types.StructType type, String name) {
        TypeToSchema.WithTypeToName converter = new TypeToSchema.WithTypeToName((Map<Types.StructType, String>)ImmutableMap.of((Object)type, (Object)name));
        TypeUtil.visit((Type)type, (TypeUtil.SchemaVisitor)converter);
        return ImmutableMap.copyOf(converter.getConversionMap());
    }

    public static org.apache.avro.Schema pruneColumns(org.apache.avro.Schema schema, Set<Integer> selectedIds) {
        return new PruneColumns(selectedIds, null).rootSchema(schema);
    }

    @Deprecated
    public static org.apache.avro.Schema pruneColumns(org.apache.avro.Schema schema, Set<Integer> selectedIds, NameMapping nameMapping) {
        return new PruneColumns(selectedIds, nameMapping).rootSchema(schema);
    }

    public static org.apache.avro.Schema buildAvroProjection(org.apache.avro.Schema schema, Schema expected, Map<String, String> renames) {
        return AvroCustomOrderSchemaVisitor.visit(schema, new BuildAvroProjection(expected, renames));
    }

    public static org.apache.avro.Schema applyNameMapping(org.apache.avro.Schema fileSchema, NameMapping nameMapping) {
        if (nameMapping != null) {
            return AvroSchemaVisitor.visit(fileSchema, new ApplyNameMapping(nameMapping));
        }
        return fileSchema;
    }

    public static boolean isTimestamptz(org.apache.avro.Schema schema) {
        LogicalType logicalType = schema.getLogicalType();
        if (logicalType instanceof LogicalTypes.TimestampMillis || logicalType instanceof LogicalTypes.TimestampMicros || logicalType instanceof LogicalTypes.TimestampNanos) {
            Object value = schema.getObjectProp(ADJUST_TO_UTC_PROP);
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return Boolean.parseBoolean((String)value);
            }
        }
        return false;
    }

    public static boolean isOptional(org.apache.avro.Schema schema) {
        return AvroSchemaUtil.isOptionSchema(schema) || schema.getType() == Schema.Type.NULL;
    }

    public static boolean isOptionSchema(org.apache.avro.Schema schema) {
        if (schema.getType() == UNION && schema.getTypes().size() == 2) {
            if (((org.apache.avro.Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                return true;
            }
            if (((org.apache.avro.Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
                return true;
            }
        }
        return false;
    }

    static org.apache.avro.Schema toOption(org.apache.avro.Schema schema) {
        switch (schema.getType()) {
            case UNION: {
                Preconditions.checkArgument((boolean)AvroSchemaUtil.isOptionSchema(schema), (String)"Union schemas are not supported: %s", (Object)schema);
                return schema;
            }
            case NULL: {
                return schema;
            }
        }
        return org.apache.avro.Schema.createUnion((org.apache.avro.Schema[])new org.apache.avro.Schema[]{NULL, schema});
    }

    static org.apache.avro.Schema fromOption(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == UNION ? 1 : 0) != 0, (String)"Expected union schema but was passed: %s", (Object)schema);
        Preconditions.checkArgument((schema.getTypes().size() == 2 ? 1 : 0) != 0, (String)"Expected optional schema, but was passed: %s", (Object)schema);
        if (((org.apache.avro.Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            return (org.apache.avro.Schema)schema.getTypes().get(1);
        }
        return (org.apache.avro.Schema)schema.getTypes().get(0);
    }

    static org.apache.avro.Schema fromOptions(List<org.apache.avro.Schema> options) {
        Preconditions.checkArgument((options.size() == 2 ? 1 : 0) != 0, (String)"Expected two schemas, but was passed: %s options", (int)options.size());
        if (options.get(0).getType() == Schema.Type.NULL) {
            return options.get(1);
        }
        return options.get(0);
    }

    public static boolean isKeyValueSchema(org.apache.avro.Schema schema) {
        return schema.getType() == RECORD && schema.getFields().size() == 2;
    }

    static boolean isVariantSchema(org.apache.avro.Schema schema) {
        if (schema.getType() != Schema.Type.RECORD || schema.getFields().size() != 2) {
            return false;
        }
        Schema.Field metadataField = schema.getField("metadata");
        Schema.Field valueField = schema.getField("value");
        return metadataField != null && metadataField.schema().getType() == Schema.Type.BYTES && valueField != null && valueField.schema().getType() == Schema.Type.BYTES;
    }

    static org.apache.avro.Schema createMap(int keyId, org.apache.avro.Schema keySchema, int valueId, org.apache.avro.Schema valueSchema) {
        String keyValueName = "k" + keyId + "_v" + valueId;
        Schema.Field keyField = new Schema.Field("key", keySchema, null, null);
        keyField.addProp(FIELD_ID_PROP, (Object)keyId);
        Schema.Field valueField = new Schema.Field("value", valueSchema, null, AvroSchemaUtil.isOptionSchema(valueSchema) ? JsonProperties.NULL_VALUE : null);
        valueField.addProp(FIELD_ID_PROP, (Object)valueId);
        return LogicalMap.get().addToSchema(org.apache.avro.Schema.createArray((org.apache.avro.Schema)org.apache.avro.Schema.createRecord((String)keyValueName, null, null, (boolean)false, (List)ImmutableList.of((Object)keyField, (Object)valueField))));
    }

    static org.apache.avro.Schema createProjectionMap(String recordName, int keyId, String keyName, org.apache.avro.Schema keySchema, int valueId, String valueName, org.apache.avro.Schema valueSchema) {
        String keyValueName = "k" + keyId + "_v" + valueId;
        Schema.Field keyField = new Schema.Field("key", keySchema, null, null);
        if (!"key".equals(keyName)) {
            keyField.addAlias(keyName);
        }
        keyField.addProp(FIELD_ID_PROP, (Object)keyId);
        Schema.Field valueField = new Schema.Field("value", valueSchema, null, AvroSchemaUtil.isOptionSchema(valueSchema) ? JsonProperties.NULL_VALUE : null);
        valueField.addProp(FIELD_ID_PROP, (Object)valueId);
        if (!"value".equals(valueName)) {
            valueField.addAlias(valueName);
        }
        org.apache.avro.Schema keyValueRecord = org.apache.avro.Schema.createRecord((String)keyValueName, null, null, (boolean)false, (List)ImmutableList.of((Object)keyField, (Object)valueField));
        if (!keyValueName.equals(recordName)) {
            keyValueRecord.addAlias(recordName);
        }
        return LogicalMap.get().addToSchema(org.apache.avro.Schema.createArray((org.apache.avro.Schema)keyValueRecord));
    }

    private static Integer getId(org.apache.avro.Schema schema, String propertyName) {
        Integer id = AvroSchemaUtil.getId(schema, propertyName, null, null);
        Preconditions.checkNotNull((Object)id, (String)"Missing expected '%s' property", (Object)propertyName);
        return id;
    }

    private static Integer getId(org.apache.avro.Schema schema, String propertyName, NameMapping nameMapping, List<String> names) {
        MappedField mappedField;
        if (schema.getType() == UNION) {
            return AvroSchemaUtil.getId(AvroSchemaUtil.fromOption(schema), propertyName, nameMapping, names);
        }
        Object id = schema.getObjectProp(propertyName);
        if (id != null) {
            return AvroSchemaUtil.toInt(id);
        }
        if (nameMapping != null && (mappedField = nameMapping.find(names)) != null) {
            return mappedField.id();
        }
        return null;
    }

    static boolean hasProperty(org.apache.avro.Schema schema, String propertyName) {
        if (schema.getType() == UNION) {
            return AvroSchemaUtil.hasProperty(AvroSchemaUtil.fromOption(schema), propertyName);
        }
        return schema.getObjectProp(propertyName) != null;
    }

    public static int getKeyId(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == MAP ? 1 : 0) != 0, (String)"Cannot get map key id for non-map schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, KEY_ID_PROP);
    }

    static Integer keyId(org.apache.avro.Schema mapSchema) {
        Object idObj = mapSchema.getObjectProp(KEY_ID_PROP);
        if (idObj != null) {
            return AvroSchemaUtil.toInt(idObj);
        }
        return null;
    }

    static Integer getKeyId(org.apache.avro.Schema schema, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Preconditions.checkArgument((schema.getType() == MAP ? 1 : 0) != 0, (String)"Cannot get map key id for non-map schema: %s", (Object)schema);
        ArrayList names = Lists.newArrayList(parentFieldNames);
        names.add("key");
        return AvroSchemaUtil.getId(schema, KEY_ID_PROP, nameMapping, names);
    }

    public static int getValueId(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == MAP ? 1 : 0) != 0, (String)"Cannot get map value id for non-map schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, VALUE_ID_PROP);
    }

    static Integer valueId(org.apache.avro.Schema mapSchema) {
        Object idObj = mapSchema.getObjectProp(VALUE_ID_PROP);
        if (idObj != null) {
            return AvroSchemaUtil.toInt(idObj);
        }
        return null;
    }

    static Integer getValueId(org.apache.avro.Schema schema, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Preconditions.checkArgument((schema.getType() == MAP ? 1 : 0) != 0, (String)"Cannot get map value id for non-map schema: %s", (Object)schema);
        ArrayList names = Lists.newArrayList(parentFieldNames);
        names.add("value");
        return AvroSchemaUtil.getId(schema, VALUE_ID_PROP, nameMapping, names);
    }

    public static int getElementId(org.apache.avro.Schema schema) {
        Preconditions.checkArgument((schema.getType() == ARRAY ? 1 : 0) != 0, (String)"Cannot get array element id for non-array schema: %s", (Object)schema);
        return AvroSchemaUtil.getId(schema, ELEMENT_ID_PROP);
    }

    static Integer elementId(org.apache.avro.Schema arraySchema) {
        Object idObj = arraySchema.getObjectProp(ELEMENT_ID_PROP);
        if (idObj != null) {
            return AvroSchemaUtil.toInt(idObj);
        }
        return null;
    }

    static Integer getElementId(org.apache.avro.Schema schema, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        Preconditions.checkArgument((schema.getType() == ARRAY ? 1 : 0) != 0, (String)"Cannot get array element id for non-array schema: %s", (Object)schema);
        ArrayList names = Lists.newArrayList(parentFieldNames);
        names.add("element");
        return AvroSchemaUtil.getId(schema, ELEMENT_ID_PROP, nameMapping, names);
    }

    public static int getFieldId(Schema.Field field) {
        Integer id = AvroSchemaUtil.getFieldId(field, null, null);
        Preconditions.checkNotNull((Object)id, (String)"Missing expected '%s' property", (Object)FIELD_ID_PROP);
        return id;
    }

    static Integer fieldId(Schema.Field field) {
        return AvroSchemaUtil.getFieldId(field, null, null);
    }

    static Integer getFieldId(Schema.Field field, NameMapping nameMapping, Iterable<String> parentFieldNames) {
        MappedField mappedField;
        Object id = field.getObjectProp(FIELD_ID_PROP);
        if (id != null) {
            return AvroSchemaUtil.toInt(id);
        }
        if (nameMapping != null && (mappedField = nameMapping.find(parentFieldNames, field.name())) != null) {
            return mappedField.id();
        }
        return null;
    }

    public static boolean hasFieldId(Schema.Field field) {
        return field.getObjectProp(FIELD_ID_PROP) != null;
    }

    private static int toInt(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new UnsupportedOperationException("Cannot coerce value to int: " + value);
    }

    static org.apache.avro.Schema copyRecord(org.apache.avro.Schema record, List<Schema.Field> newFields, String newName) {
        org.apache.avro.Schema copy;
        if (newName != null) {
            copy = org.apache.avro.Schema.createRecord((String)newName, (String)record.getDoc(), null, (boolean)record.isError(), newFields);
            copy.addAlias(record.getName(), record.getNamespace() == null ? "" : record.getNamespace());
        } else {
            copy = org.apache.avro.Schema.createRecord((String)record.getName(), (String)record.getDoc(), (String)record.getNamespace(), (boolean)record.isError(), newFields);
        }
        for (Map.Entry prop : record.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        return copy;
    }

    static Schema.Field copyField(Schema.Field field, org.apache.avro.Schema newSchema, String newName) {
        Schema.Field copy = new Schema.Field(newName, newSchema, field.doc(), field.defaultVal(), field.order());
        for (Map.Entry prop : field.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        if (!newName.equals(field.name())) {
            copy.addAlias(field.name());
        }
        return copy;
    }

    static org.apache.avro.Schema replaceElement(org.apache.avro.Schema array, org.apache.avro.Schema elementSchema) {
        Preconditions.checkArgument((array.getType() == ARRAY ? 1 : 0) != 0, (String)"Cannot invoke replaceElement on non array schema: %s", (Object)array);
        org.apache.avro.Schema copy = org.apache.avro.Schema.createArray((org.apache.avro.Schema)elementSchema);
        for (Map.Entry prop : array.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        return copy;
    }

    static org.apache.avro.Schema replaceValue(org.apache.avro.Schema map, org.apache.avro.Schema valueSchema) {
        Preconditions.checkArgument((map.getType() == MAP ? 1 : 0) != 0, (String)"Cannot invoke replaceValue on non map schema: %s", (Object)map);
        org.apache.avro.Schema copy = org.apache.avro.Schema.createMap((org.apache.avro.Schema)valueSchema);
        for (Map.Entry prop : map.getObjectProps().entrySet()) {
            copy.addProp((String)prop.getKey(), prop.getValue());
        }
        return copy;
    }

    public static String makeCompatibleName(String name) {
        if (!AvroSchemaUtil.validAvroName(name)) {
            return AvroSchemaUtil.sanitize(name);
        }
        return name;
    }

    static boolean validAvroName(String name) {
        int length = name.length();
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Empty name");
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            char character = name.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') continue;
            return false;
        }
        return true;
    }

    static String sanitize(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(name.length());
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            sb.append(AvroSchemaUtil.sanitize(first));
        } else {
            sb.append(first);
        }
        for (int i = 1; i < length; ++i) {
            char character = name.charAt(i);
            if (!Character.isLetterOrDigit(character) && character != '_') {
                sb.append(AvroSchemaUtil.sanitize(character));
                continue;
            }
            sb.append(character);
        }
        return sb.toString();
    }

    private static String sanitize(char character) {
        if (Character.isDigit(character)) {
            return "_" + character;
        }
        return "_x" + Integer.toHexString(character).toUpperCase(Locale.ROOT);
    }
}

