/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.quarkus.config;

import io.smallrye.config.ConfigMapping;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.polaris.core.config.PolarisConfiguration;
import org.apache.polaris.service.config.ReservedProperties;

@ConfigMapping(prefix="polaris.reserved-properties")
public interface QuarkusReservedProperties
extends ReservedProperties {
    default public List<String> prefixes() {
        return List.of("polaris.");
    }

    default public Set<String> allowlist() {
        return AllowlistHolder.INSTANCE;
    }

    public static class AllowlistHolder {
        static final Set<String> INSTANCE = AllowlistHolder.computeAllowlist();

        private static Set<String> computeAllowlist() {
            HashSet<String> allowlist = new HashSet<String>();
            PolarisConfiguration.getAllConfigurations().forEach(c -> {
                if (c.hasCatalogConfig()) {
                    allowlist.add(c.catalogConfig());
                }
                if (c.hasCatalogConfigUnsafe()) {
                    allowlist.add(c.catalogConfigUnsafe());
                }
            });
            return allowlist;
        }
    }
}

