/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.TablePrivilege;

public class TableGrant
extends GrantResource {
    @NotNull
    private final List<String> namespace;
    @NotNull
    @Size(min=1, max=256)
    private final @NotNull @Size(min=1, max=256) String tableName;
    @NotNull
    @Valid
    private final TablePrivilege privilege;

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="namespace", required=true)
    public List<String> getNamespace() {
        return this.namespace;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="tableName", required=true)
    public String getTableName() {
        return this.tableName;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="privilege", required=true)
    public TablePrivilege getPrivilege() {
        return this.privilege;
    }

    @JsonCreator
    public TableGrant(@JsonProperty(value="namespace", required=true) List<String> namespace, @JsonProperty(value="tableName", required=true) String tableName, @JsonProperty(value="privilege", required=true) TablePrivilege privilege, @JsonProperty(value="type", required=true) GrantResource.TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
        this.tableName = tableName;
        this.privilege = privilege;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(List<String> namespace, String tableName, TablePrivilege privilege, GrantResource.TypeEnum type) {
        return new Builder(namespace, tableName, privilege, type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableGrant tableGrant = (TableGrant)o;
        return super.equals(o) && Objects.equals(this.namespace, tableGrant.namespace) && Objects.equals(this.tableName, tableGrant.tableName) && Objects.equals((Object)this.privilege, (Object)tableGrant.privilege);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.namespace, super.hashCode(), this.tableName, super.hashCode(), this.privilege});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableGrant {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    tableName: ").append(this.toIndentedString(this.tableName)).append("\n");
        sb.append("    privilege: ").append(this.toIndentedString((Object)this.privilege)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private List<String> namespace;
        private String tableName;
        private TablePrivilege privilege;
        private GrantResource.TypeEnum type;

        private Builder() {
        }

        private Builder(List<String> namespace, String tableName, TablePrivilege privilege, GrantResource.TypeEnum type) {
            this.namespace = Objects.requireNonNullElse(namespace, new ArrayList());
            this.tableName = tableName;
            this.privilege = privilege;
            this.type = type;
        }

        public Builder setNamespace(List<String> namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setPrivilege(TablePrivilege privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setType(GrantResource.TypeEnum type) {
            this.type = type;
            return this;
        }

        public TableGrant build() {
            TableGrant inst = new TableGrant(this.namespace, this.tableName, this.privilege, this.type);
            return inst;
        }
    }
}

