/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.persistence.impl.eclipselink;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.polaris.core.context.RealmContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

sealed interface PolarisEclipseLinkPersistenceUnit {
    public Map<String, String> loadProperties() throws IOException;

    public EntityManagerFactory createEntityManagerFactory(@Nonnull RealmContext var1) throws IOException;

    public static PolarisEclipseLinkPersistenceUnit locatePersistenceUnit(@Nullable String confFile, @Nullable String persistenceUnitName) throws IOException {
        int splitPosition;
        if (persistenceUnitName == null) {
            persistenceUnitName = "polaris";
        }
        if (confFile == null) {
            confFile = "META-INF/persistence.xml";
        }
        if ((splitPosition = confFile.indexOf("!/")) != -1) {
            String jarPrefix = confFile.substring(0, splitPosition);
            String descriptorPath = confFile.substring(splitPosition + 2);
            URL jarUrl = PolarisEclipseLinkPersistenceUnit.classpathResource(jarPrefix);
            if (jarUrl != null) {
                URL confUrl = URI.create("jar:" + String.valueOf(jarUrl) + "!/" + descriptorPath).toURL();
                return new ClasspathResourcePolarisEclipseLinkPersistenceUnit(confUrl, confFile, persistenceUnitName);
            }
            jarUrl = PolarisEclipseLinkPersistenceUnit.fileSystemPath(jarPrefix).toUri().toURL();
            URL confUrl = URI.create("jar:" + String.valueOf(jarUrl) + "!/" + descriptorPath).toURL();
            return new JarFilePolarisEclipseLinkPersistenceUnit(confUrl, jarUrl, descriptorPath, persistenceUnitName);
        }
        URL resource = PolarisEclipseLinkPersistenceUnit.classpathResource(confFile);
        if (resource != null) {
            return new ClasspathResourcePolarisEclipseLinkPersistenceUnit(resource, confFile, persistenceUnitName);
        }
        try {
            return new FileSystemPolarisEclipseLinkPersistenceUnit(PolarisEclipseLinkPersistenceUnit.fileSystemPath(confFile), persistenceUnitName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot find classpath resource or file: " + confFile, e);
        }
    }

    private static Path fileSystemPath(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalStateException("Not a regular file: " + pathStr);
        }
        return path.normalize().toAbsolutePath();
    }

    @Nullable
    private static URL classpathResource(String resourceName) throws IOException {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(resourceName);
        if (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (resources.hasMoreElements()) {
                throw new IllegalStateException("Multiple resources found in classpath for " + resourceName);
            }
            return resource;
        }
        return null;
    }

    private static Map<String, String> internalLoadProperties(@Nonnull URL confFile, @Nonnull String persistenceUnitName) throws IOException {
        HashMap<String, String> hashMap;
        block9: {
            InputStream input = confFile.openStream();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(input);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String expression = "/persistence/persistence-unit[@name='" + persistenceUnitName + "']/properties/property";
                NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
                HashMap<String, String> properties = new HashMap<String, String>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    NamedNodeMap nodeMap = nodeList.item(i).getAttributes();
                    properties.put(nodeMap.getNamedItem("name").getNodeValue(), nodeMap.getNamedItem("value").getNodeValue());
                }
                hashMap = properties;
                if (input == null) break block9;
            }
            catch (Throwable factory) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable) {
                            factory.addSuppressed(throwable);
                        }
                    }
                    throw factory;
                }
                catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                    String str = String.format("Cannot find or parse the configuration file %s for persistence-unit %s", confFile, persistenceUnitName);
                    throw new IOException(str, e);
                }
            }
            input.close();
        }
        return hashMap;
    }

    private static Map<String, String> transformJdbcUrl(Map<String, String> properties, RealmContext realmContext) {
        if (properties.containsKey("jakarta.persistence.jdbc.url")) {
            properties.put("jakarta.persistence.jdbc.url", properties.get("jakarta.persistence.jdbc.url").replace("{realm}", realmContext.getRealmIdentifier()));
        }
        return properties;
    }

    public record ClasspathResourcePolarisEclipseLinkPersistenceUnit(URL resource, String resourceName, String persistenceUnitName) implements PolarisEclipseLinkPersistenceUnit
    {
        @Override
        public Map<String, String> loadProperties() throws IOException {
            Map<String, String> properties = PolarisEclipseLinkPersistenceUnit.internalLoadProperties(this.resource, this.persistenceUnitName);
            properties.put("eclipselink.persistencexml", this.resourceName);
            return properties;
        }

        @Override
        public EntityManagerFactory createEntityManagerFactory(@Nonnull RealmContext realmContext) throws IOException {
            Map<String, String> properties = PolarisEclipseLinkPersistenceUnit.transformJdbcUrl(this.loadProperties(), realmContext);
            return Persistence.createEntityManagerFactory((String)this.persistenceUnitName, properties);
        }
    }

    public record JarFilePolarisEclipseLinkPersistenceUnit(URL confUrl, URL jarUrl, String descriptorPath, String persistenceUnitName) implements PolarisEclipseLinkPersistenceUnit
    {
        @Override
        public Map<String, String> loadProperties() throws IOException {
            Map<String, String> properties = PolarisEclipseLinkPersistenceUnit.internalLoadProperties(this.confUrl, this.persistenceUnitName);
            properties.put("eclipselink.persistencexml", this.descriptorPath);
            return properties;
        }

        @Override
        public EntityManagerFactory createEntityManagerFactory(@Nonnull RealmContext realmContext) throws IOException {
            Map<String, String> properties = PolarisEclipseLinkPersistenceUnit.transformJdbcUrl(this.loadProperties(), realmContext);
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                EntityManagerFactory entityManagerFactory;
                try (URLClassLoader currentClassLoader = new URLClassLoader(new URL[]{this.jarUrl}, this.getClass().getClassLoader());){
                    Thread.currentThread().setContextClassLoader(currentClassLoader);
                    entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, properties);
                }
                return entityManagerFactory;
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        }
    }

    public record FileSystemPolarisEclipseLinkPersistenceUnit(Path path, String persistenceUnitName) implements PolarisEclipseLinkPersistenceUnit
    {
        @Override
        public Map<String, String> loadProperties() throws IOException {
            Map<String, String> properties = PolarisEclipseLinkPersistenceUnit.internalLoadProperties(this.path.toUri().toURL(), this.persistenceUnitName);
            Path archiveDirectory = this.path.getParent();
            String descriptorPath = archiveDirectory.getParent().relativize(this.path).toString();
            properties.put("eclipselink.persistencexml", descriptorPath);
            return properties;
        }

        @Override
        public EntityManagerFactory createEntityManagerFactory(@Nonnull RealmContext realmContext) throws IOException {
            Map<String, String> properties = PolarisEclipseLinkPersistenceUnit.transformJdbcUrl(this.loadProperties(), realmContext);
            Path archiveDirectory = this.path.getParent();
            ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                EntityManagerFactory entityManagerFactory;
                try (URLClassLoader currentClassLoader = new URLClassLoader(new URL[]{archiveDirectory.getParent().toUri().toURL()}, this.getClass().getClassLoader());){
                    Thread.currentThread().setContextClassLoader(currentClassLoader);
                    entityManagerFactory = Persistence.createEntityManagerFactory((String)this.persistenceUnitName, properties);
                }
                return entityManagerFactory;
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
        }
    }
}

