/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.diagnostics;

import java.util.concurrent.atomic.LongAdder;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;

public class ServiceCounter {
    private final LongAdder totalCount = new LongAdder();
    private final LongAdder errorCount = new LongAdder();

    public void record(ServiceRequest service) {
        service.getFuture().whenComplete((r, ex) -> {
            this.totalCount.increment();
            if (ex != null) {
                this.errorCount.increment();
            }
        });
    }

    public ServiceCounterDataType getServiceCounter() {
        return new ServiceCounterDataType(Unsigned.uint((long)this.totalCount.sum()), Unsigned.uint((long)this.errorCount.sum()));
    }
}

