/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.unary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.unary.UnaryViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LikeViewExpression
extends UnaryViewExpression {
    private final String pattern;
    private final Optional<Character> escape;
    private final boolean isNot;

    public LikeViewExpression(ViewExpression expression, String pattern, Optional<Character> escape, boolean isNot) {
        super(expression);
        this.pattern = pattern;
        this.escape = escape;
        this.isNot = isNot;
    }

    public LikeViewExpression(ViewExpression expression, String pattern, boolean isNot) {
        super(expression);
        this.pattern = pattern;
        this.escape = Optional.empty();
        this.isNot = isNot;
    }

    public LikeViewExpression(ByteBuffer byteBuffer) {
        super(ViewExpression.deserialize(byteBuffer));
        this.pattern = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        byte judge = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        switch (judge) {
            case -1: 
            case 0: {
                this.escape = Optional.empty();
                this.isNot = false;
                break;
            }
            case 1: {
                this.escape = Optional.empty();
                this.isNot = true;
                break;
            }
            case 2: {
                this.escape = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer) ? Optional.of(Character.valueOf(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer).charAt(0))) : Optional.empty();
                this.isNot = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value in LikeViewExpression: " + judge);
            }
        }
    }

    public LikeViewExpression(InputStream inputStream) {
        super(ViewExpression.deserialize(inputStream));
        try {
            this.pattern = ReadWriteIOUtils.readString((InputStream)inputStream);
            byte judge = ReadWriteIOUtils.readByte((InputStream)inputStream);
            switch (judge) {
                case -1: 
                case 0: {
                    this.escape = Optional.empty();
                    this.isNot = false;
                    break;
                }
                case 1: {
                    this.escape = Optional.empty();
                    this.isNot = true;
                    break;
                }
                case 2: {
                    this.escape = ReadWriteIOUtils.readBool((InputStream)inputStream) ? Optional.of(Character.valueOf(ReadWriteIOUtils.readString((InputStream)inputStream).charAt(0))) : Optional.empty();
                    this.isNot = ReadWriteIOUtils.readBool((InputStream)inputStream);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value in LikeViewExpression: " + judge);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLikeExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.LIKE;
    }

    @Override
    public String toString(boolean isRoot) {
        String basicString = this.expression.toString(false) + (this.isNot ? "NOT LIKE " : "LIKE ") + "pattern = '" + this.pattern + "'";
        if (this.escape.isPresent()) {
            basicString = basicString + " escape = '" + this.escape.get() + "'";
        }
        if (isRoot) {
            return basicString;
        }
        return "( " + basicString + " )";
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.pattern, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((byte)2, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.escape.isPresent(), (ByteBuffer)byteBuffer);
        if (this.escape.isPresent()) {
            ReadWriteIOUtils.write((String)this.escape.get().toString(), (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.isNot, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pattern, (OutputStream)stream);
        ReadWriteIOUtils.write((byte)2, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.escape.isPresent(), (OutputStream)stream);
        if (this.escape.isPresent()) {
            ReadWriteIOUtils.write((String)this.escape.get().toString(), (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isNot, (OutputStream)stream);
    }

    public String getPattern() {
        return this.pattern;
    }

    public Optional<Character> getEscape() {
        return this.escape;
    }

    public boolean isNot() {
        return this.isNot;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LikeViewExpression target = (LikeViewExpression)obj;
        return this.expression.equals(target.expression) && this.pattern.equals(target.pattern) && this.escape.equals(target.escape) && this.isNot == target.isNot;
    }
}

