/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.detector;

import java.util.List;
import java.util.Optional;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.IFailureDetector;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.tsfile.utils.Preconditions;

public class FixedDetector
implements IFailureDetector {
    private final long heartbeatTimeoutNs;

    public FixedDetector(long heartbeatTimeoutNs) {
        this.heartbeatTimeoutNs = heartbeatTimeoutNs;
    }

    @Override
    public boolean isAvailable(Object id, List<AbstractHeartbeatSample> history) {
        AbstractHeartbeatSample lastSample;
        AbstractHeartbeatSample abstractHeartbeatSample = lastSample = history.isEmpty() ? null : history.get(history.size() - 1);
        if (lastSample != null) {
            Preconditions.checkArgument((lastSample instanceof NodeHeartbeatSample || lastSample instanceof RegionHeartbeatSample ? 1 : 0) != 0);
        }
        long lastSendTime = Optional.ofNullable(lastSample).map(AbstractHeartbeatSample::getSampleLogicalTimestamp).orElse(0L);
        long currentNanoTime = System.nanoTime();
        return currentNanoTime - lastSendTime <= this.heartbeatTimeoutNs;
    }
}

