/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ViewDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=511");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=513");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=512");
    private final NodeId viewId;
    private final DateTime timestamp;
    private final UInteger viewVersion;

    public ViewDescription(NodeId viewId, DateTime timestamp, UInteger viewVersion) {
        this.viewId = viewId;
        this.timestamp = timestamp;
        this.viewVersion = viewVersion;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getViewId() {
        return this.viewId;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public UInteger getViewVersion() {
        return this.viewVersion;
    }

    protected ViewDescription(ViewDescriptionBuilder<?, ?> b) {
        super(b);
        this.viewId = ((ViewDescriptionBuilder)b).viewId;
        this.timestamp = ((ViewDescriptionBuilder)b).timestamp;
        this.viewVersion = ((ViewDescriptionBuilder)b).viewVersion;
    }

    public static ViewDescriptionBuilder<?, ?> builder() {
        return new ViewDescriptionBuilderImpl();
    }

    public ViewDescriptionBuilder<?, ?> toBuilder() {
        return new ViewDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewDescription)) {
            return false;
        }
        ViewDescription other = (ViewDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        NodeId this$viewId = this.getViewId();
        NodeId other$viewId = other.getViewId();
        if (this$viewId == null ? other$viewId != null : !((Object)this$viewId).equals(other$viewId)) {
            return false;
        }
        DateTime this$timestamp = this.getTimestamp();
        DateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        UInteger this$viewVersion = this.getViewVersion();
        UInteger other$viewVersion = other.getViewVersion();
        return !(this$viewVersion == null ? other$viewVersion != null : !((Object)this$viewVersion).equals(other$viewVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ViewDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NodeId $viewId = this.getViewId();
        result = result * 59 + ($viewId == null ? 43 : ((Object)$viewId).hashCode());
        DateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        UInteger $viewVersion = this.getViewVersion();
        result = result * 59 + ($viewVersion == null ? 43 : ((Object)$viewVersion).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ViewDescription(viewId=" + this.getViewId() + ", timestamp=" + this.getTimestamp() + ", viewVersion=" + this.getViewVersion() + ")";
    }

    private static final class ViewDescriptionBuilderImpl
    extends ViewDescriptionBuilder<ViewDescription, ViewDescriptionBuilderImpl> {
        private ViewDescriptionBuilderImpl() {
        }

        @Override
        protected ViewDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public ViewDescription build() {
            return new ViewDescription(this);
        }
    }

    public static abstract class ViewDescriptionBuilder<C extends ViewDescription, B extends ViewDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private NodeId viewId;
        private DateTime timestamp;
        private UInteger viewVersion;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ViewDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ViewDescription instance, ViewDescriptionBuilder<?, ?> b) {
            b.viewId(instance.viewId);
            b.timestamp(instance.timestamp);
            b.viewVersion(instance.viewVersion);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B viewId(NodeId viewId) {
            this.viewId = viewId;
            return (B)this.self();
        }

        public B timestamp(DateTime timestamp) {
            this.timestamp = timestamp;
            return (B)this.self();
        }

        public B viewVersion(UInteger viewVersion) {
            this.viewVersion = viewVersion;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ViewDescription.ViewDescriptionBuilder(super=" + super.toString() + ", viewId=" + this.viewId + ", timestamp=" + this.timestamp + ", viewVersion=" + this.viewVersion + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ViewDescription> {
        @Override
        public Class<ViewDescription> getType() {
            return ViewDescription.class;
        }

        @Override
        public ViewDescription decode(SerializationContext context, UaDecoder decoder) {
            NodeId viewId = decoder.readNodeId("ViewId");
            DateTime timestamp = decoder.readDateTime("Timestamp");
            UInteger viewVersion = decoder.readUInt32("ViewVersion");
            return new ViewDescription(viewId, timestamp, viewVersion);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ViewDescription value) {
            encoder.writeNodeId("ViewId", value.getViewId());
            encoder.writeDateTime("Timestamp", value.getTimestamp());
            encoder.writeUInt32("ViewVersion", value.getViewVersion());
        }
    }
}

