/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.persistence.util.HashMapIndex;

public class FileBasedIndex
extends HashMapIndex {
    private FileSystemResource file;
    private long lastModified = -1L;

    public FileBasedIndex(FileSystemResource file) throws FileSystemException, IOException {
        this.file = file;
        if (!file.exists()) {
            file.makeParentDirs();
            file.getOutputStream().close();
        }
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() {
        block6: {
            try {
                long modTime = this.file.lastModified();
                if (modTime == this.lastModified) break block6;
                this.lastModified = modTime;
                try (InputStream in = this.file.getInputStream();){
                    Properties properties = new Properties();
                    properties.load(in);
                    for (Object name : Collections.list(properties.propertyNames())) {
                        String string = name.toString();
                        Integer index = Integer.valueOf(properties.getProperty(string));
                        this.stringToIndex.put(string, index);
                        this.indexToString.put(index, string);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load lookup table", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void save() {
        try {
            try (OutputStream out = this.file.getOutputStream();){
                Properties properties = new Properties();
                for (Map.Entry entry : this.stringToIndex.entrySet()) {
                    properties.setProperty((String)entry.getKey(), ((Integer)entry.getValue()).toString());
                }
                properties.store(out, "string index");
            }
            this.lastModified = this.file.lastModified();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to store lookup table", e);
        }
    }
}

