/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.hierarchy;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.collections4.list.AbstractLinkedListJava21;
import org.apache.jackrabbit.jcr2spi.hierarchy.EntryFactory;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.spi.Name;

class LinkedEntries
extends AbstractLinkedListJava21 {
    private AbstractLinkedListJava21.Node<?> header;
    private volatile int modCount;
    private final EntryFactory factory;
    private final NodeEntry parent;

    LinkedEntries(EntryFactory factory, NodeEntry parent) {
        this.factory = factory;
        this.parent = parent;
        this.init();
    }

    protected void addNode(AbstractLinkedListJava21.Node nodeToInsert, AbstractLinkedListJava21.Node insertBeforeNode) {
        super.addNode(nodeToInsert, insertBeforeNode);
        ++this.modCount;
    }

    protected void removeNode(AbstractLinkedListJava21.Node node) {
        super.removeNode(node);
        ++this.modCount;
    }

    @Override
    protected void removeAllNodes() {
        super.removeAllNodes();
        ++this.modCount;
    }

    protected LinkNode getLinkNode(NodeEntry nodeEntry) {
        Iterator<LinkNode> it = this.linkNodeIterator();
        while (it.hasNext()) {
            LinkNode ln = it.next();
            if (ln.getNodeEntry() != nodeEntry) continue;
            return ln;
        }
        return null;
    }

    protected LinkNode getHeader() {
        return (LinkNode)this.header;
    }

    LinkNode add(NodeEntry cne, int index) {
        LinkNode ln = new LinkNode(cne, index);
        this.addNode((AbstractLinkedListJava21.Node)ln, (AbstractLinkedListJava21.Node)this.getHeader());
        return ln;
    }

    LinkNode addAfter(NodeEntry cne, int index, LinkNode insertAfter) {
        LinkNode newNode;
        if (insertAfter == null) {
            newNode = new LinkNode(cne, index);
            this.addNode((AbstractLinkedListJava21.Node)newNode, (AbstractLinkedListJava21.Node)this.getHeader());
        } else if (insertAfter.getNextLinkNode() == null) {
            newNode = this.add(cne, index);
        } else {
            newNode = new LinkNode(cne, index);
            this.addNode((AbstractLinkedListJava21.Node)newNode, (AbstractLinkedListJava21.Node)insertAfter.getNextLinkNode());
        }
        return newNode;
    }

    LinkNode removeNodeEntry(NodeEntry cne) {
        LinkNode ln = this.getLinkNode(cne);
        if (ln != null) {
            ln.remove();
        }
        return ln;
    }

    void reorderNode(LinkNode insert, LinkNode before) {
        this.removeNode((AbstractLinkedListJava21.Node)insert);
        if (before == null) {
            this.addNode((AbstractLinkedListJava21.Node)insert, (AbstractLinkedListJava21.Node)this.getHeader());
        } else {
            this.addNode((AbstractLinkedListJava21.Node)insert, (AbstractLinkedListJava21.Node)before);
        }
    }

    protected AbstractLinkedListJava21.Node createNode(Object value) {
        return new LinkNode(value, 1);
    }

    protected AbstractLinkedListJava21.Node createHeaderNode() {
        this.header = new LinkNode();
        return this.header;
    }

    protected Iterator<LinkNode> linkNodeIterator() {
        return new LinkNodeIterator();
    }

    private class LinkNodeIterator
    implements Iterator<LinkNode> {
        private LinkNode next;
        private final int expectedModCount;

        private LinkNodeIterator() {
            this.next = LinkedEntries.this.getHeader().getNextLinkNode();
            this.expectedModCount = LinkedEntries.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.checkModCount();
            return this.next != LinkedEntries.this.header;
        }

        @Override
        public LinkNode next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            LinkNode n = this.next;
            this.next = this.next.getNextLinkNode();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private void checkModCount() {
            if (this.expectedModCount != LinkedEntries.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected final class LinkNode
    extends AbstractLinkedListJava21.Node {
        protected final Name qName;

        protected LinkNode() {
            this.qName = null;
        }

        protected LinkNode(Object value, int index) {
            super(index > 1 ? value : new SoftReference<Object>(value));
            this.qName = ((NodeEntry)value).getName();
        }

        protected void setValue(Object value) {
            throw new UnsupportedOperationException("Not implemented");
        }

        protected Object getValue() {
            Object val = super.getValue();
            NodeEntry ne = val == null ? null : (val instanceof Reference ? (NodeEntry)((Reference)val).get() : (NodeEntry)val);
            if (ne == null && this != LinkedEntries.this.getHeader()) {
                ne = LinkedEntries.this.factory.createNodeEntry(LinkedEntries.this.parent, this.qName, null);
                super.setValue(new SoftReference<NodeEntry>(ne));
            }
            return ne;
        }

        public NodeEntry getNodeEntry() {
            return (NodeEntry)this.getValue();
        }

        public void remove() {
            LinkedEntries.this.removeNode((AbstractLinkedListJava21.Node)this);
        }

        public LinkNode getNextLinkNode() {
            return (LinkNode)super.getNextNode();
        }

        public LinkNode getPreviousLinkNode() {
            return (LinkNode)super.getPreviousNode();
        }
    }
}

