/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs.db;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.db.DbFileSystem;
import org.apache.jackrabbit.core.util.db.ConnectionHelper;
import org.apache.jackrabbit.core.util.db.DerbyConnectionHelper;

public class DerbyFileSystem
extends DbFileSystem {
    protected boolean shutdownOnClose;

    public DerbyFileSystem() {
        this.schema = "derby";
        this.driver = "org.apache.derby.jdbc.EmbeddedDriver";
        this.shutdownOnClose = true;
        this.initialized = false;
    }

    public boolean getShutdownOnClose() {
        return this.shutdownOnClose;
    }

    public void setShutdownOnClose(boolean shutdownOnClose) {
        this.shutdownOnClose = shutdownOnClose;
    }

    @Override
    protected ConnectionHelper createConnectionHelper(DataSource dataSrc) throws Exception {
        return new DerbyConnectionHelper(dataSrc, false);
    }

    @Override
    public void close() throws FileSystemException {
        super.close();
        if (this.shutdownOnClose) {
            try {
                ((DerbyConnectionHelper)this.conHelper).shutDown(this.driver);
            }
            catch (SQLException e) {
                throw new FileSystemException("failed to shutdown Derby", e);
            }
        }
    }
}

