/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.query;

import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.commons.query.QueryObjectModelBuilderRegistry;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.WorkspaceManager;
import org.apache.jackrabbit.jcr2spi.query.QueryImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryObjectModelImpl
extends QueryImpl
implements QueryObjectModel {
    private final QueryObjectModelTree qomTree;

    public QueryObjectModelImpl(Session session, ManagerProvider mgrProvider, ItemManager itemMgr, WorkspaceManager wspManager, QueryObjectModelTree qomTree, Node node) throws InvalidQueryException, RepositoryException {
        super(session, mgrProvider, itemMgr, wspManager, QueryObjectModelImpl.getSQL2ForQOM(qomTree), "JCR-SQL2", node);
        this.qomTree = qomTree;
    }

    @Override
    public String getLanguage() {
        return "JCR-JQOM";
    }

    @Override
    public Source getSource() {
        return this.qomTree.getSource();
    }

    @Override
    public Constraint getConstraint() {
        return this.qomTree.getConstraint();
    }

    @Override
    public Ordering[] getOrderings() {
        return this.qomTree.getOrderings();
    }

    @Override
    public Column[] getColumns() {
        return this.qomTree.getColumns();
    }

    private static String getSQL2ForQOM(QueryObjectModelTree qomTree) throws InvalidQueryException {
        return QueryObjectModelBuilderRegistry.getQueryObjectModelBuilder("JCR-JQOM").toString(new DummyQOM(qomTree));
    }

    private static class DummyQOM
    implements QueryObjectModel {
        private final QueryObjectModelTree qomTree;

        public DummyQOM(QueryObjectModelTree qomTree) {
            this.qomTree = qomTree;
        }

        @Override
        public Source getSource() {
            return this.qomTree.getSource();
        }

        @Override
        public Constraint getConstraint() {
            return this.qomTree.getConstraint();
        }

        @Override
        public Ordering[] getOrderings() {
            return this.qomTree.getOrderings();
        }

        @Override
        public Column[] getColumns() {
            return this.qomTree.getColumns();
        }

        @Override
        public QueryResult execute() throws InvalidQueryException, RepositoryException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLimit(long limit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOffset(long offset) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStatement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLanguage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getBindVariableNames() throws RepositoryException {
            throw new UnsupportedOperationException();
        }
    }
}

