/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.HashMap;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.stream.Field;

public class DelegatingFieldParser
implements FieldParser<ParsedField> {
    private final FieldParser<? extends ParsedField> defaultParser;
    private final Map<String, FieldParser<? extends ParsedField>> parsers;

    public DelegatingFieldParser(FieldParser<? extends ParsedField> defaultParser) {
        this.defaultParser = defaultParser;
        this.parsers = new HashMap<String, FieldParser<? extends ParsedField>>();
    }

    public void setFieldParser(String name, FieldParser<? extends ParsedField> parser) {
        this.parsers.put(name.toLowerCase(), parser);
    }

    public FieldParser<? extends ParsedField> getParser(String name) {
        FieldParser<? extends ParsedField> field = this.parsers.get(name.toLowerCase());
        if (field == null) {
            return this.defaultParser;
        }
        return field;
    }

    private FieldParser<? extends ParsedField> getParser(Field rawField) {
        FieldParser<? extends ParsedField> field = this.parsers.get(rawField.getNameLowerCase());
        if (field == null) {
            return this.defaultParser;
        }
        return field;
    }

    @Override
    public ParsedField parse(Field rawField, DecodeMonitor monitor) {
        FieldParser<? extends ParsedField> parser = this.getParser(rawField);
        return parser.parse(rawField, monitor);
    }
}

