/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.james.mime4j.codec.QuotedPrintableOutputStream;

public class QuotedPrintableOutputStreamBench {
    public static void main(String[] args) throws Exception {
        byte[] data = QuotedPrintableOutputStreamBench.initData(1024);
        NullOutputStream nullOut = new NullOutputStream();
        QuotedPrintableOutputStream base64Out = new QuotedPrintableOutputStream((OutputStream)nullOut, true);
        for (int i = 0; i < 2000; ++i) {
            base64Out.write(data);
        }
        Thread.sleep(100L);
        long t0 = System.currentTimeMillis();
        int repetitions = 500000;
        for (int i = 0; i < 500000; ++i) {
            base64Out.write(data);
        }
        base64Out.close();
        long dt = System.currentTimeMillis() - t0;
        long totalBytes = (long)data.length * 500000L;
        double mbPerSec = (double)totalBytes / 1024.0 / 1024.0 / ((double)dt / 1000.0);
        System.out.println(dt + " ms");
        System.out.println(totalBytes + " bytes");
        System.out.println(mbPerSec + " mb/sec");
    }

    private static byte[] initData(int size) {
        Random random = new Random(size);
        byte[] data = new byte[size];
        random.nextBytes(data);
        return data;
    }
}

