/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class BatchSizes {
    public static final int DEFAULT_BATCH_SIZE = 200;
    private final int fetchMetadata;
    private final int fetchHeaders;
    private final int fetchBody;
    private final int fetchFull;
    private final Optional<Integer> copyBatchSize;
    private final Optional<Integer> moveBatchSize;

    public static BatchSizes defaultValues() {
        return new Builder().build();
    }

    public static BatchSizes uniqueBatchSize(int batchSize) {
        return new Builder().fetchMetadata(batchSize).fetchHeaders(batchSize).fetchBody(batchSize).fetchFull(batchSize).copyBatchSize(batchSize).moveBatchSize(batchSize).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private BatchSizes(int fetchMetadata, int fetchHeaders, int fetchBody, int fetchFull, Optional<Integer> copyBatchSize, Optional<Integer> moveBatchSize) {
        this.fetchMetadata = fetchMetadata;
        this.fetchHeaders = fetchHeaders;
        this.fetchBody = fetchBody;
        this.fetchFull = fetchFull;
        this.copyBatchSize = copyBatchSize;
        this.moveBatchSize = moveBatchSize;
    }

    public int getFetchMetadata() {
        return this.fetchMetadata;
    }

    public int getFetchHeaders() {
        return this.fetchHeaders;
    }

    public int getFetchBody() {
        return this.fetchBody;
    }

    public int getFetchFull() {
        return this.fetchFull;
    }

    public Optional<Integer> getCopyBatchSize() {
        return this.copyBatchSize;
    }

    public Optional<Integer> getMoveBatchSize() {
        return this.moveBatchSize;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof BatchSizes) {
            BatchSizes other = (BatchSizes)obj;
            return Objects.equal((Object)this.fetchMetadata, (Object)other.fetchMetadata) && Objects.equal((Object)this.fetchHeaders, (Object)other.fetchHeaders) && Objects.equal((Object)this.fetchBody, (Object)other.fetchBody) && Objects.equal((Object)this.fetchFull, (Object)other.fetchFull) && Objects.equal(this.copyBatchSize, other.copyBatchSize) && Objects.equal(this.moveBatchSize, other.moveBatchSize);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fetchMetadata, this.fetchHeaders, this.fetchBody, this.fetchFull, this.copyBatchSize, this.moveBatchSize});
    }

    public String toString() {
        return MoreObjects.toStringHelper(BatchSizes.class).add("fetchMetadata", this.fetchMetadata).add("fetchHeaders", this.fetchHeaders).add("fetchBody", this.fetchBody).add("fetchFull", this.fetchFull).add("copyBatchSize", this.copyBatchSize).add("moveBatchSize", this.moveBatchSize).toString();
    }

    public static class Builder {
        private Optional<Integer> fetchMetadata = Optional.empty();
        private Optional<Integer> fetchHeaders = Optional.empty();
        private Optional<Integer> fetchBody = Optional.empty();
        private Optional<Integer> fetchFull = Optional.empty();
        private Optional<Integer> copyBatchSize = Optional.empty();
        private Optional<Integer> moveBatchSize = Optional.empty();

        private Builder() {
        }

        public Builder fetchMetadata(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchMetadata' must be greater than zero");
            this.fetchMetadata = Optional.of(batchSize);
            return this;
        }

        public Builder fetchHeaders(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchHeaders' must be greater than zero");
            this.fetchHeaders = Optional.of(batchSize);
            return this;
        }

        public Builder fetchBody(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchBody' must be greater than zero");
            this.fetchBody = Optional.of(batchSize);
            return this;
        }

        public Builder fetchFull(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'fetchFull' must be greater than zero");
            this.fetchFull = Optional.of(batchSize);
            return this;
        }

        public Builder copyBatchSize(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'copyBatchSize' must be greater than zero");
            this.copyBatchSize = Optional.of(batchSize);
            return this;
        }

        public Builder moveBatchSize(int batchSize) {
            Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0, (Object)"'moveBatchSize' must be greater than zero");
            this.moveBatchSize = Optional.of(batchSize);
            return this;
        }

        public BatchSizes build() {
            return new BatchSizes(this.fetchMetadata.orElse(200), this.fetchHeaders.orElse(200), this.fetchBody.orElse(200), this.fetchFull.orElse(200), this.copyBatchSize, this.moveBatchSize);
        }
    }
}

