/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Create;
import org.apache.james.backends.cassandra.components.CassandraModule;

public interface CassandraSieveRepositoryModule {
    public static final CassandraModule MODULE = CassandraModule.builder().table("sieve").comment("Holds SIEVE scripts.").options(options -> options).statement(statement -> (Create)((Create)((Create)statement.addPartitionKey("user_name", DataType.text()).addClusteringColumn("script_name", DataType.text()).addColumn("script_content", DataType.text())).addColumn("is_active", DataType.cboolean())).addColumn("size", DataType.bigint())).table("sieve_space").comment("Holds per user current space occupied by SIEVE scripts.").options(options -> options).statement(statement -> (Create)statement.addPartitionKey("user_name", DataType.text()).addColumn("space_used", DataType.counter())).table("sieve_quota").comment("Holds per user size limitations for SIEVE script storage.").options(options -> options).statement(statement -> (Create)statement.addPartitionKey("user_name", DataType.text()).addColumn("quota", DataType.bigint())).table("sieve_cluster_quota").comment("Holds default size limitations for SIEVE script storage.").options(options -> options).statement(statement -> (Create)statement.addPartitionKey("name", DataType.text()).addColumn("value", DataType.bigint())).table("sieve_active").comment("Denormalisation table. Allows per user direct active SIEVE script retrieval.").options(options -> options).statement(statement -> (Create)((Create)statement.addPartitionKey("user_name", DataType.text()).addColumn("script_name", DataType.text())).addColumn("date", DataType.timestamp())).build();
}

