/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta.strats;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.VersionMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.AbstractVersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;

public abstract class ColumnVersionStrategy
extends AbstractVersionStrategy {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(ColumnVersionStrategy.class);

    protected abstract int getJavaType();

    protected int getJavaType(int i) {
        throw new AbstractMethodError(_loc.get("multi-column-version-unsupported", this.getAlias()).toString());
    }

    protected abstract Object nextVersion(Object var1);

    protected int compare(Object v1, Object v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        if (v1.getClass().isArray()) {
            if (!v2.getClass().isArray()) {
                throw new InternalException();
            }
            return this.compare((Object[])v1, (Object[])v2);
        }
        if (v1.getClass() != v2.getClass()) {
            if (v1 instanceof Number && !(v1 instanceof BigDecimal)) {
                v1 = new BigDecimal(((Number)v1).doubleValue());
            }
            if (v2 instanceof Number && !(v2 instanceof BigDecimal)) {
                v2 = new BigDecimal(((Number)v2).doubleValue());
            }
        }
        return ((Comparable)v1).compareTo(v2);
    }

    protected int compare(Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            throw new InternalException();
        }
        int total = 0;
        for (int i = 0; i < a1.length; ++i) {
            int c = this.compare(a1[i], a2[i]);
            if (c > 0) {
                return 1;
            }
            total += c;
        }
        return total;
    }

    @Override
    public void map(boolean adapt) {
        ClassMapping cls = this.vers.getClassMapping();
        if (cls.getJoinablePCSuperclassMapping() != null || cls.getEmbeddingMetaData() != null) {
            throw new MetaDataException(_loc.get("not-base-vers", cls));
        }
        VersionMappingInfo info = this.vers.getMappingInfo();
        info.assertNoJoin(this.vers, true);
        info.assertNoForeignKey(this.vers, !adapt);
        info.assertNoUnique(this.vers, false);
        if (info.getColumns().size() > 1) {
            Column[] templates = new Column[info.getColumns().size()];
            for (int i = 0; i < info.getColumns().size(); ++i) {
                templates[i] = new Column();
                Column infoColumn = info.getColumns().get(i);
                templates[i].setTableIdentifier(infoColumn.getTableIdentifier());
                templates[i].setType(infoColumn.getType());
                templates[i].setSize(infoColumn.getSize());
                templates[i].setDecimalDigits(infoColumn.getDecimalDigits());
                templates[i].setJavaType(this.getJavaType(i));
                templates[i].setIdentifier(infoColumn.getIdentifier());
            }
            Column[] cols = info.getColumns(this.vers, templates, adapt);
            for (Column col : cols) {
                col.setVersionStrategy(this);
            }
            this.vers.setColumns(cols);
            this.vers.setColumnIO(info.getColumnIO());
        } else {
            Column tmplate = new Column();
            tmplate.setJavaType(this.getJavaType());
            DBDictionary dict = this.vers.getMappingRepository().getDBDictionary();
            DBIdentifier versName = DBIdentifier.newColumn("versn", dict != null ? dict.delimitAll() : false);
            tmplate.setIdentifier(versName);
            Column[] cols = info.getColumns(this.vers, new Column[]{tmplate}, adapt);
            cols[0].setVersionStrategy(this);
            this.vers.setColumns(cols);
            this.vers.setColumnIO(info.getColumnIO());
            Index idx = info.getIndex(this.vers, cols, adapt);
            this.vers.setIndex(idx);
        }
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Column[] cols = this.vers.getColumns();
        ColumnIO io = this.vers.getColumnIO();
        Object initial = this.nextVersion(null);
        for (int i = 0; i < cols.length; ++i) {
            Row row = rm.getRow(cols[i].getTable(), 1, sm, true);
            if (!io.isInsertable(i, initial == null)) continue;
            row.setObject(cols[i], this.getColumnValue(initial, i));
        }
        Object nextVersion = initial;
        sm.setNextVersion(nextVersion);
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Column[] cols = this.vers.getColumns();
        if (cols == null || cols.length == 0 || !sm.isDirty() && !sm.isVersionUpdateRequired()) {
            return;
        }
        Object curVersion = sm.getVersion();
        Object nextVersion = this.nextVersion(curVersion);
        for (int i = 0; i < cols.length; ++i) {
            Row row = rm.getRow(cols[i].getTable(), 0, sm, true);
            row.setFailedObject(sm.getManagedInstance());
            if (curVersion != null && sm.isVersionCheckRequired()) {
                row.whereObject(cols[i], this.getColumnValue(curVersion, i));
                if (this.isSecondaryColumn(cols[i], sm)) {
                    ForeignKey[] fks;
                    for (ForeignKey fk : fks = cols[i].getTable().getForeignKeys()) {
                        row.whereForeignKey(fk, sm);
                    }
                }
            }
            if (!this.vers.getColumnIO().isUpdatable(i, nextVersion == null)) continue;
            row.setObject(cols[i], this.getColumnValue(nextVersion, i));
        }
        if (nextVersion != null) {
            sm.setNextVersion(nextVersion);
        }
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Column[] cols = this.vers.getColumns();
        Object curVersion = sm.getVersion();
        for (int i = 0; i < cols.length; ++i) {
            ForeignKey[] fks;
            Row row = rm.getRow(cols[i].getTable(), 2, sm, true);
            row.setFailedObject(sm.getManagedInstance());
            Object cur = this.getColumnValue(curVersion, i);
            if (cur == null) continue;
            row.whereObject(cols[i], cur);
            if (!this.isSecondaryColumn(cols[i], sm)) continue;
            for (ForeignKey fk : fks = cols[i].getTable().getForeignKeys()) {
                row.whereForeignKey(fk, sm);
            }
        }
    }

    @Override
    public boolean select(Select sel, ClassMapping mapping) {
        sel.select(this.vers.getColumns());
        return true;
    }

    @Override
    public Object load(OpenJPAStateManager sm, JDBCStore store, Result res) throws SQLException {
        return this.load(sm, store, res, null);
    }

    @Override
    public Object load(OpenJPAStateManager sm, JDBCStore store, Result res, Joins joins) throws SQLException {
        Column[] cols = this.vers.getColumns();
        if (!res.contains(cols[0], joins)) {
            return null;
        }
        Object version = this.populateFromResult(res, joins);
        if (sm != null) {
            sm.setVersion(version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkVersion(OpenJPAStateManager sm, JDBCStore store, boolean updateVersion) throws SQLException {
        Column[] cols = this.vers.getColumns();
        Select sel = store.getSQLFactory().newSelect();
        sel.select(cols);
        sel.wherePrimaryKey(sm.getObjectId(), this.vers.getClassMapping(), store);
        JDBCFetchConfiguration fetch = store.getFetchConfiguration();
        if (!updateVersion && fetch.getReadLockLevel() >= 30) {
            fetch = (JDBCFetchConfiguration)fetch.clone();
            fetch.setReadLockLevel(0);
        }
        try (Result res = sel.execute(store, fetch);){
            Object dbVersion;
            boolean refresh;
            if (!res.next()) {
                boolean bl = false;
                return bl;
            }
            Object memVersion = sm.getVersion();
            boolean bl = refresh = this.compare(memVersion, dbVersion = this.populateFromResult(res, null)) < 0;
            if (updateVersion) {
                sm.setVersion(dbVersion);
            }
            boolean bl2 = !refresh;
            return bl2;
        }
    }

    @Override
    public int compareVersion(Object v1, Object v2) {
        if (v1 == v2) {
            return 3;
        }
        if (v1 == null || v2 == null) {
            return 4;
        }
        int cmp = this.compare(v1, v2);
        if (cmp < 0) {
            return 2;
        }
        if (cmp > 0) {
            return 1;
        }
        return 3;
    }

    Object populateFromResult(Result res, Joins joins) throws SQLException {
        if (res == null) {
            return null;
        }
        Column[] cols = this.vers.getColumns();
        Object[] values = new Object[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            values[i] = res.getObject(cols[i], null, joins);
        }
        return cols.length == 1 ? values[0] : values;
    }

    Object getColumnValue(Object o, int idx) {
        if (o == null) {
            return null;
        }
        if (o.getClass().isArray()) {
            return Array.get(o, idx);
        }
        return o;
    }

    boolean isSecondaryColumn(Column col, OpenJPAStateManager sm) {
        for (ClassMapping mapping = (ClassMapping)sm.getMetaData(); mapping != null; mapping = mapping.getPCSuperclassMapping()) {
            if (mapping.getTable() != col.getTable()) continue;
            return false;
        }
        return true;
    }
}

