/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.Set;
import org.apache.james.mailbox.acl.GroupMembershipResolver;

public class SimpleGroupMembershipResolver
implements GroupMembershipResolver {
    private final Set<Membership> memberships = new HashSet<Membership>(32);

    public void addMembership(String group, String user) {
        this.memberships.add(new Membership(user, group));
    }

    @Override
    public boolean isMember(String user, String group) {
        return this.memberships.contains(new Membership(user, group));
    }

    public static class Membership {
        private final String group;
        private final String user;

        public Membership(String user, String group) {
            this.group = group;
            this.user = user;
        }

        public boolean equals(Object o) {
            if (o instanceof Membership) {
                Membership that = (Membership)o;
                return Objects.equal(this.user, that.user) && Objects.equal(this.group, that.group);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.group, this.user);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("group", this.group).add("user", this.user).toString();
        }
    }
}

