/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class MailboxCounters {
    private final long count;
    private final long unseen;

    public static Builder builder() {
        return new Builder();
    }

    private MailboxCounters(long count, long unseen) {
        this.count = count;
        this.unseen = unseen;
    }

    public long getCount() {
        return this.count;
    }

    public long getUnseen() {
        return this.unseen;
    }

    public final boolean equals(Object o) {
        if (o instanceof MailboxCounters) {
            MailboxCounters that = (MailboxCounters)o;
            return Objects.equal(this.count, that.count) && Objects.equal(this.unseen, that.unseen);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.count, this.unseen);
    }

    public static class Builder {
        private Optional<Long> count = Optional.empty();
        private Optional<Long> unseen = Optional.empty();

        public Builder count(long count) {
            this.count = Optional.of(count);
            return this;
        }

        public Builder unseen(long unseen) {
            this.unseen = Optional.of(unseen);
            return this;
        }

        public MailboxCounters build() {
            Preconditions.checkState(this.count.isPresent(), "count is compulsory");
            Preconditions.checkState(this.unseen.isPresent(), "unseen is compulsory");
            return new MailboxCounters(this.count.get(), this.unseen.get());
        }
    }
}

