/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.mail.internet.AddressException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;

public class DsnParameters {
    public static final String NOTIFY_PARAMETER = "NOTIFY";
    public static final String RFC_822_PREFIX = "rfc822;";
    public static final String ORCPT_PARAMETER = "ORCPT";
    public static final String ENVID_PARAMETER = "ENVID";
    public static final String RET_PARAMETER = "RET";
    private final Optional<EnvId> envIdParameter;
    private final Optional<Ret> retParameter;
    private final ImmutableMap<MailAddress, RecipientDsnParameters> rcptParameters;

    public static Builder builder() {
        return new Builder();
    }

    public static Optional<DsnParameters> of(Optional<EnvId> envIdParameter, Optional<Ret> retParameter, ImmutableMap<MailAddress, RecipientDsnParameters> rcptParameters) {
        if (envIdParameter.isEmpty() && retParameter.isEmpty() && rcptParameters.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DsnParameters(envIdParameter, retParameter, rcptParameters));
    }

    public static Optional<DsnParameters> fromAttributeValue(DsnAttributeValues dsnAttributeValues) {
        Optional<EnvId> envId = dsnAttributeValues.getEnvIdAttributeValue().map(EnvId::fromAttributeValue);
        Optional<Ret> ret = dsnAttributeValues.getRetAttributeValue().map(Ret::fromAttributeValue);
        Map notify = dsnAttributeValues.getNotifyAttributeValue().map(mapAttributeValue -> ((Map)mapAttributeValue.value()).entrySet().stream().map(Throwing.function(entry -> Pair.of(new MailAddress((String)entry.getKey()), Notify.fromAttributeValue((AttributeValue)entry.getValue())))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue))).orElse(ImmutableMap.of());
        Map orcpt = dsnAttributeValues.getOrcptAttributeValue().map(mapAttributeValue -> ((Map)mapAttributeValue.value()).entrySet().stream().map(Throwing.function(entry -> Pair.of(new MailAddress((String)entry.getKey()), new MailAddress((String)((AttributeValue)entry.getValue()).value())))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue))).orElse(ImmutableMap.of());
        ImmutableCollection rcpts = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)notify.keySet())).addAll((Iterable)orcpt.keySet())).build();
        ImmutableMap<MailAddress, RecipientDsnParameters> recipientDsnParameters = rcpts.stream().map(rcpt -> Pair.of(rcpt, new RecipientDsnParameters(Optional.ofNullable((EnumSet)notify.get(rcpt)), Optional.ofNullable((MailAddress)orcpt.get(rcpt))))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        return DsnParameters.of(envId, ret, recipientDsnParameters);
    }

    DsnParameters(Optional<EnvId> envIdParameter, Optional<Ret> retParameter, ImmutableMap<MailAddress, RecipientDsnParameters> rcptParameters) {
        this.envIdParameter = envIdParameter;
        this.retParameter = retParameter;
        this.rcptParameters = rcptParameters;
    }

    public DsnParameters withRcptParameters(Map<MailAddress, RecipientDsnParameters> rcptParameters) {
        return new DsnParameters(this.envIdParameter, this.retParameter, ImmutableMap.copyOf(rcptParameters));
    }

    public Optional<EnvId> getEnvIdParameter() {
        return this.envIdParameter;
    }

    public Optional<Ret> getRetParameter() {
        return this.retParameter;
    }

    public ImmutableMap<MailAddress, RecipientDsnParameters> getRcptParameters() {
        return this.rcptParameters;
    }

    public DsnAttributeValues toAttributes() {
        Optional<AttributeValue<String>> envIdAttributeValue = this.envIdParameter.map(EnvId::asString).map(AttributeValue::of);
        Optional<AttributeValue<String>> retAttributeValue = this.retParameter.map(Enum::toString).map(AttributeValue::of);
        Optional<AttributeValue<Map<String, AttributeValue<String>>>> notifyAttributeValue = AttributeValue.of((Map)this.rcptParameters.entrySet().stream().filter(entry -> ((RecipientDsnParameters)entry.getValue()).getNotifyParameter().isPresent()).map(entry -> Pair.of(((MailAddress)entry.getKey()).asString(), Notify.toAttributeValue(((RecipientDsnParameters)entry.getValue()).getNotifyParameter().get()))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue))).asMapAttributeValueOf(String.class);
        Optional<AttributeValue<Map<String, AttributeValue<String>>>> orcptAttributeValue = AttributeValue.of((Map)this.rcptParameters.entrySet().stream().filter(entry -> ((RecipientDsnParameters)entry.getValue()).getOrcptParameter().isPresent()).map(entry -> Pair.of(((MailAddress)entry.getKey()).asString(), AttributeValue.of(((RecipientDsnParameters)entry.getValue()).getOrcptParameter().get().asString()))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue))).asMapAttributeValueOf(String.class);
        return new DsnAttributeValues(notifyAttributeValue, orcptAttributeValue, envIdAttributeValue, retAttributeValue);
    }

    public final boolean equals(Object o) {
        if (o instanceof DsnParameters) {
            DsnParameters that = (DsnParameters)o;
            return Objects.equals(this.envIdParameter, that.envIdParameter) && Objects.equals(this.retParameter, that.retParameter) && Objects.equals(this.rcptParameters, that.rcptParameters);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.envIdParameter, this.retParameter, this.rcptParameters);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("envIdParameter", this.envIdParameter).add("retParameter", this.retParameter).add("rcptParameters", this.rcptParameters).toString();
    }

    public static class Builder {
        private Optional<EnvId> envIdParameter = Optional.empty();
        private Optional<Ret> retParameter = Optional.empty();
        private final ImmutableMap.Builder<MailAddress, RecipientDsnParameters> rcptParameters = ImmutableMap.builder();

        public Builder envId(EnvId envId) {
            this.envIdParameter = Optional.of(envId);
            return this;
        }

        public Builder ret(Ret ret) {
            this.retParameter = Optional.of(ret);
            return this;
        }

        public Builder rcptParameters(ImmutableMap<MailAddress, RecipientDsnParameters> rcptParameters) {
            this.rcptParameters.putAll(rcptParameters);
            return this;
        }

        public Builder addRcptParameter(MailAddress recipient, RecipientDsnParameters parameters) {
            this.rcptParameters.put(recipient, parameters);
            return this;
        }

        public Optional<DsnParameters> build() {
            return DsnParameters.of(this.envIdParameter, this.retParameter, this.rcptParameters.build());
        }
    }

    public static class DsnAttributeValues {
        private static final AttributeName ENVID_ATTRIBUTE_NAME = AttributeName.of("dsn-envid");
        private static final AttributeName RET_ATTRIBUTE_NAME = AttributeName.of("dsn-ret");
        private static final AttributeName NOTIFY_ATTRIBUTE_NAME = AttributeName.of("dsn-notify");
        private static final AttributeName ORCPT_ATTRIBUTE_NAME = AttributeName.of("dsn-orcpt");
        private final Optional<AttributeValue<Map<String, AttributeValue<String>>>> notifyAttributeValue;
        private final Optional<AttributeValue<Map<String, AttributeValue<String>>>> orcptAttributeValue;
        private final Optional<AttributeValue<String>> envIdAttributeValue;
        private final Optional<AttributeValue<String>> retAttributeValue;

        public static DsnAttributeValues extract(Map<AttributeName, Attribute> attributesMap) {
            Optional<AttributeValue<String>> envId = Optional.ofNullable(attributesMap.get(ENVID_ATTRIBUTE_NAME)).flatMap(attribute -> attribute.getValue().asAttributeValueOf(String.class));
            Optional<AttributeValue<String>> ret = Optional.ofNullable(attributesMap.get(RET_ATTRIBUTE_NAME)).flatMap(attribute -> attribute.getValue().asAttributeValueOf(String.class));
            Optional<AttributeValue<Map<String, AttributeValue<String>>>> notify = Optional.ofNullable(attributesMap.get(NOTIFY_ATTRIBUTE_NAME)).flatMap(attribute -> attribute.getValue().asMapAttributeValueOf(String.class));
            Optional<AttributeValue<Map<String, AttributeValue<String>>>> orcpt = Optional.ofNullable(attributesMap.get(ORCPT_ATTRIBUTE_NAME)).flatMap(attribute -> attribute.getValue().asMapAttributeValueOf(String.class));
            return new DsnAttributeValues(notify, orcpt, envId, ret);
        }

        public static void forEachDsnAttributeName(Consumer<AttributeName> action) {
            action.accept(ENVID_ATTRIBUTE_NAME);
            action.accept(RET_ATTRIBUTE_NAME);
            action.accept(NOTIFY_ATTRIBUTE_NAME);
            action.accept(ORCPT_ATTRIBUTE_NAME);
        }

        public DsnAttributeValues(Optional<AttributeValue<Map<String, AttributeValue<String>>>> notifyAttributeValue, Optional<AttributeValue<Map<String, AttributeValue<String>>>> orcptAttributeValue, Optional<AttributeValue<String>> envIdAttributeValue, Optional<AttributeValue<String>> retAttributeValue) {
            this.notifyAttributeValue = notifyAttributeValue;
            this.orcptAttributeValue = orcptAttributeValue;
            this.envIdAttributeValue = envIdAttributeValue;
            this.retAttributeValue = retAttributeValue;
        }

        public Optional<AttributeValue<Map<String, AttributeValue<String>>>> getNotifyAttributeValue() {
            return this.notifyAttributeValue;
        }

        public Optional<AttributeValue<Map<String, AttributeValue<String>>>> getOrcptAttributeValue() {
            return this.orcptAttributeValue;
        }

        public Optional<AttributeValue<String>> getEnvIdAttributeValue() {
            return this.envIdAttributeValue;
        }

        public Optional<AttributeValue<String>> getRetAttributeValue() {
            return this.retAttributeValue;
        }

        public List<Attribute> asAttributes() {
            ImmutableList.Builder result = ImmutableList.builder();
            this.envIdAttributeValue.map(value -> new Attribute(ENVID_ATTRIBUTE_NAME, (AttributeValue<?>)value)).ifPresent(result::add);
            this.retAttributeValue.map(value -> new Attribute(RET_ATTRIBUTE_NAME, (AttributeValue<?>)value)).ifPresent(result::add);
            this.notifyAttributeValue.map(value -> new Attribute(NOTIFY_ATTRIBUTE_NAME, (AttributeValue<?>)value)).ifPresent(result::add);
            this.orcptAttributeValue.map(value -> new Attribute(ORCPT_ATTRIBUTE_NAME, (AttributeValue<?>)value)).ifPresent(result::add);
            return result.build();
        }
    }

    public static class RecipientDsnParameters {
        private final Optional<EnumSet<Notify>> notifyParameter;
        private final Optional<MailAddress> orcptParameter;

        public static Optional<RecipientDsnParameters> fromSMTPArgLine(Map<String, String> rcptToArgLine) {
            Optional<EnumSet<Notify>> notifyParameter = Optional.ofNullable(rcptToArgLine.get(DsnParameters.NOTIFY_PARAMETER)).map(Notify::parse);
            Optional<MailAddress> orcptParameter = Optional.ofNullable(rcptToArgLine.get(DsnParameters.ORCPT_PARAMETER)).map(RecipientDsnParameters::parseOrcpt);
            return RecipientDsnParameters.of(notifyParameter, orcptParameter);
        }

        public static Optional<RecipientDsnParameters> of(Optional<EnumSet<Notify>> notifyParameter, Optional<MailAddress> orcptParameter) {
            if (notifyParameter.isEmpty() && orcptParameter.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new RecipientDsnParameters(notifyParameter, orcptParameter));
        }

        public static RecipientDsnParameters of(EnumSet<Notify> notifyParameter, MailAddress orcptParameter) {
            return new RecipientDsnParameters(Optional.of(notifyParameter), Optional.of(orcptParameter));
        }

        public static RecipientDsnParameters of(MailAddress orcptParameter) {
            return new RecipientDsnParameters(Optional.empty(), Optional.of(orcptParameter));
        }

        public static RecipientDsnParameters of(EnumSet<Notify> notifyParameter) {
            return new RecipientDsnParameters(Optional.of(notifyParameter), Optional.empty());
        }

        private static MailAddress parseOrcpt(String input) {
            Preconditions.checkArgument(input.startsWith(DsnParameters.RFC_822_PREFIX), "ORCPT must start with the rfc822 prefix");
            String addressPart = input.substring(DsnParameters.RFC_822_PREFIX.length());
            try {
                return new MailAddress(addressPart);
            }
            catch (AddressException e) {
                throw new IllegalArgumentException(addressPart + " could not be parsed", e);
            }
        }

        RecipientDsnParameters(Optional<EnumSet<Notify>> notifyParameter, Optional<MailAddress> orcptParameter) {
            this.notifyParameter = notifyParameter;
            this.orcptParameter = orcptParameter;
        }

        public Optional<EnumSet<Notify>> getNotifyParameter() {
            return this.notifyParameter;
        }

        public Optional<MailAddress> getOrcptParameter() {
            return this.orcptParameter;
        }

        public final boolean equals(Object o) {
            if (o instanceof RecipientDsnParameters) {
                RecipientDsnParameters that = (RecipientDsnParameters)o;
                return Objects.equals(this.notifyParameter, that.notifyParameter) && Objects.equals(this.orcptParameter, that.orcptParameter);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.notifyParameter, this.orcptParameter);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("notifyParameter", this.notifyParameter).add("orcptParameter", this.orcptParameter).toString();
        }
    }

    public static enum Notify {
        NEVER,
        SUCCESS,
        FAILURE,
        DELAY;


        public static EnumSet<Notify> fromAttributeValue(AttributeValue<String> attributeValue) {
            return Notify.parse(attributeValue.value());
        }

        public static AttributeValue<String> toAttributeValue(EnumSet<Notify> value) {
            return AttributeValue.of(Joiner.on(',').join(value));
        }

        public static EnumSet<Notify> parse(String input) {
            Preconditions.checkNotNull(input);
            return Notify.validate(EnumSet.copyOf(Splitter.on(",").omitEmptyStrings().trimResults().splitToStream(input).map(string -> Notify.parseValue(string).orElseThrow(() -> new IllegalArgumentException(string + " could not be associated with any RCPT NOTIFY value"))).collect(ImmutableList.toImmutableList())));
        }

        public static Optional<Notify> parseValue(String input) {
            return Arrays.stream(Notify.values()).filter(value -> value.toString().equalsIgnoreCase(input)).findAny();
        }

        private static EnumSet<Notify> validate(EnumSet<Notify> input) {
            Preconditions.checkArgument(!input.contains((Object)NEVER) || input.size() == 1, "RCPT Notify should not contain over values when containing never");
            return input;
        }
    }

    public static class EnvId {
        private final String value;

        public static Optional<EnvId> fromSMTPArgLine(Map<String, String> mailFromArgLine) {
            return Optional.ofNullable(mailFromArgLine.get(DsnParameters.ENVID_PARAMETER)).map(EnvId::of);
        }

        public static EnvId fromAttributeValue(AttributeValue<String> attributeValue) {
            return EnvId.of(attributeValue.value());
        }

        public static EnvId of(String value) {
            Preconditions.checkNotNull(value);
            Preconditions.checkArgument(XText.isValid(value), "According to RFC-3461 EnvId should be a valid xtext, thus composed of CHARs between \"!\" (33) and \"~\" (126) inclusive, except for \"+\" and \"=\" or follow the hexadecimal escape sequence.");
            return new EnvId(value);
        }

        private EnvId(String value) {
            this.value = value;
        }

        public String asString() {
            return this.value;
        }

        public AttributeValue<String> toAttributeValue() {
            return AttributeValue.of(this.value);
        }

        public final boolean equals(Object o) {
            if (o instanceof EnvId) {
                EnvId that = (EnvId)o;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("value", this.value).toString();
        }
    }

    public static enum Ret {
        FULL,
        HDRS;


        public static Optional<Ret> fromSMTPArgLine(Map<String, String> mailFromArgLine) {
            return Optional.ofNullable(mailFromArgLine.get(DsnParameters.RET_PARAMETER)).map(input -> Ret.parse(input).orElseThrow(() -> new IllegalArgumentException(input + " is not a supported value for RET DSN parameter")));
        }

        public static Ret fromAttributeValue(AttributeValue<String> attributeValue) {
            return Ret.parse(attributeValue.value()).orElseThrow(() -> new IllegalArgumentException((String)attributeValue.value() + " is not a supported value for RET DSN parameter"));
        }

        public static AttributeValue<String> toAttributeValue(Ret value) {
            return AttributeValue.of(value.toString());
        }

        public static Optional<Ret> parse(String string) {
            Preconditions.checkNotNull(string);
            return Arrays.stream(Ret.values()).filter(value -> value.toString().equalsIgnoreCase(string)).findAny();
        }
    }

    public static class XText {
        private static final CharMatcher ESCAPE_CHAR = CharMatcher.isNot('+');
        private static CharMatcher XCHAR_VALIDATOR = CharMatcher.inRange('!', '~').and(CharMatcher.isNot('=')).and(ESCAPE_CHAR);
        private static CharMatcher HEX_VALIDATOR = CharMatcher.inRange('0', '9').or(CharMatcher.inRange('A', 'F'));

        public static String encode(String text) {
            if (XText.isOnlyXChar(text)) {
                return text;
            }
            StringBuilder result = new StringBuilder();
            text.chars().forEach(i -> XText.encode(i, result));
            return result.toString();
        }

        private static StringBuilder encode(int i, StringBuilder result) {
            if (i < 33 || i > 126 || i == 43 || i == 61) {
                return result.append('+').append(String.format("%02X", i));
            }
            return result.append((char)i);
        }

        public static String decode(String text) {
            Preconditions.checkArgument(XText.isValid(text), "Decoding invalid xtext '%s'", (Object)text);
            if (XCHAR_VALIDATOR.matchesAllOf(text)) {
                return text;
            }
            char[] chars = text.toCharArray();
            StringBuilder result = new StringBuilder();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (c == '+') {
                    char hex1 = chars[i + 1];
                    char hex2 = chars[i + 2];
                    char hexChar = (char)Integer.parseInt("" + hex1 + hex2, 16);
                    result.append(hexChar);
                    i += 3;
                    continue;
                }
                result.append(c);
                ++i;
            }
            return result.toString();
        }

        public static boolean isValid(String text) {
            if (XText.isOnlyXChar(text)) {
                return true;
            }
            char[] chars = text.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (!XCHAR_VALIDATOR.matches(c)) {
                    if (c == '+') {
                        if (!XText.isValidEscapeSequence(chars, i)) {
                            return false;
                        }
                        i += 3;
                        continue;
                    }
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean isValidEscapeSequence(char[] chars, int i) {
            if (i + 3 > chars.length) {
                return false;
            }
            return HEX_VALIDATOR.matches(chars[i + 1]) && HEX_VALIDATOR.matches(chars[i + 2]);
        }

        private static boolean isOnlyXChar(String text) {
            return XCHAR_VALIDATOR.matchesAllOf(text);
        }
    }
}

