/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.snapshot.CloneSnapshotResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class CloneSnapshotRequest
extends RequestBase
implements JsonpSerializable {
    private final String indices;
    @Deprecated
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Time clusterManagerTimeout;
    private final String repository;
    private final String snapshot;
    private final String targetSnapshot;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<CloneSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloneSnapshotRequest::setupCloneSnapshotRequestDeserializer);
    public static final Endpoint<CloneSnapshotRequest, CloneSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CloneSnapshotRequest, CloneSnapshotResponse>(request -> "PUT", request -> {
        boolean _targetSnapshot = true;
        int _repository = 2;
        int _snapshot = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_clone");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.targetSnapshot, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.clusterManagerTimeout != null) {
            params.put("cluster_manager_timeout", request.clusterManagerTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CloneSnapshotResponse._DESERIALIZER);

    private CloneSnapshotRequest(Builder builder) {
        this.indices = ApiTypeHelper.requireNonNull(builder.indices, this, "indices");
        this.masterTimeout = builder.masterTimeout;
        this.clusterManagerTimeout = builder.clusterManagerTimeout;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.targetSnapshot = ApiTypeHelper.requireNonNull(builder.targetSnapshot, this, "targetSnapshot");
        this.timeout = builder.timeout;
    }

    public static CloneSnapshotRequest of(Function<Builder, ObjectBuilder<CloneSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String indices() {
        return this.indices;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Time clusterManagerTimeout() {
        return this.clusterManagerTimeout;
    }

    public final String repository() {
        return this.repository;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    public final String targetSnapshot() {
        return this.targetSnapshot;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.write(this.indices);
    }

    protected static void setupCloneSnapshotRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringDeserializer(), "indices");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CloneSnapshotRequest> {
        private String indices;
        @Deprecated
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Time clusterManagerTimeout;
        private String repository;
        private String snapshot;
        private String targetSnapshot;
        @Nullable
        private Time timeout;

        public final Builder indices(String value) {
            this.indices = value;
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        @Deprecated
        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder clusterManagerTimeout(@Nullable Time value) {
            this.clusterManagerTimeout = value;
            return this;
        }

        public final Builder clusterManagerTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.clusterManagerTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder targetSnapshot(String value) {
            this.targetSnapshot = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public CloneSnapshotRequest build() {
            this._checkSingleUse();
            return new CloneSnapshotRequest(this);
        }
    }
}

