/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.james.util.UnitParser;

public class DurationParser {
    private DurationParser() {
    }

    public static Duration parse(String rawString) throws NumberFormatException {
        return DurationParser.parse(rawString, ChronoUnit.MILLIS);
    }

    public static Duration parse(String rawString, ChronoUnit defaultUnit) throws NumberFormatException {
        UnitParser.ParsingResult parsingResult = UnitParser.parse(rawString);
        Duration unitAsDuration = parsingResult.getUnit().map(s -> Unit.parse(s).getDuration()).orElse(defaultUnit.getDuration());
        return DurationParser.computeDuration(unitAsDuration, parsingResult.getNumber());
    }

    private static Duration computeDuration(Duration unitAsDuration, long time) {
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"Duration amount should be positive");
        return unitAsDuration.multipliedBy(time);
    }

    private static enum Unit {
        MILLI_SECONDS((List<String>)ImmutableList.of((Object)"ms", (Object)"msec", (Object)"msecs"), ChronoUnit.MILLIS),
        SECONDS((List<String>)ImmutableList.of((Object)"s", (Object)"sec", (Object)"secs", (Object)"second", (Object)"seconds"), ChronoUnit.SECONDS),
        MINUTES((List<String>)ImmutableList.of((Object)"m", (Object)"min", (Object)"mins", (Object)"minute", (Object)"minutes"), ChronoUnit.MINUTES),
        HOURS((List<String>)ImmutableList.of((Object)"h", (Object)"hour", (Object)"hours"), ChronoUnit.HOURS),
        DAYS((List<String>)ImmutableList.of((Object)"d", (Object)"day", (Object)"days"), ChronoUnit.DAYS),
        WEEKS((List<String>)ImmutableList.of((Object)"w", (Object)"week", (Object)"weeks"), ChronoUnit.WEEKS),
        MONTH((List<String>)ImmutableList.of((Object)"month", (Object)"months"), ChronoUnit.MONTHS),
        YEARS((List<String>)ImmutableList.of((Object)"y", (Object)"year", (Object)"years"), ChronoUnit.YEARS);

        private final List<String> validPatterns;
        private final ChronoUnit unit;

        public static ChronoUnit parse(String string) {
            return Arrays.stream(Unit.values()).filter(value -> value.validPatterns.contains(string.toLowerCase(Locale.US))).findFirst().map(entry -> entry.unit).orElseThrow(() -> new NumberFormatException("Unknown unit: " + string));
        }

        private Unit(List<String> validPatterns, ChronoUnit unit) {
            this.validPatterns = validPatterns;
            this.unit = unit;
        }
    }
}

