/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.impl;

import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import org.apache.james.jdkim.api.BodyHasher;
import org.apache.james.jdkim.canon.CompoundOutputStream;
import org.apache.james.jdkim.exceptions.FailException;
import org.apache.james.jdkim.impl.BodyHasherImpl;

public class CompoundBodyHasher
implements BodyHasher {
    private final OutputStream o;
    private final Map<String, BodyHasherImpl> bodyHashJobs;
    private final Map<String, FailException> signatureExceptions;

    public CompoundBodyHasher(Map<String, BodyHasherImpl> bodyHashJobs, Hashtable<String, FailException> signatureExceptions) {
        this.bodyHashJobs = bodyHashJobs;
        this.signatureExceptions = signatureExceptions;
        if (bodyHashJobs.size() == 1) {
            this.o = bodyHashJobs.values().iterator().next().getOutputStream();
        } else {
            LinkedList<OutputStream> outputStreams = new LinkedList<OutputStream>();
            for (BodyHasherImpl bhj : bodyHashJobs.values()) {
                outputStreams.add(bhj.getOutputStream());
            }
            this.o = new CompoundOutputStream(outputStreams);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.o;
    }

    public Map<String, BodyHasherImpl> getBodyHashJobs() {
        return this.bodyHashJobs;
    }

    public Map<String, FailException> getSignatureExceptions() {
        return this.signatureExceptions;
    }
}

