/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.JmapChange;
import org.apache.james.jmap.api.change.MailboxChange;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.SessionProvider;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MailboxAndEmailChange
implements JmapChange {
    private final AccountId accountId;
    private final EmailChange emailChange;
    private final MailboxChange mailboxChange;

    public MailboxAndEmailChange(AccountId accountId, EmailChange emailChange, MailboxChange mailboxChange) {
        Preconditions.checkArgument((boolean)accountId.equals(emailChange.getAccountId()));
        Preconditions.checkArgument((boolean)accountId.equals(mailboxChange.getAccountId()));
        this.accountId = accountId;
        this.emailChange = emailChange;
        this.mailboxChange = mailboxChange;
    }

    @Override
    public AccountId getAccountId() {
        return this.accountId;
    }

    public EmailChange getEmailChange() {
        return this.emailChange;
    }

    public MailboxChange getMailboxChange() {
        return this.mailboxChange;
    }

    public static class Factory {
        private final State.Factory stateFactory;
        private final MessageIdManager messageIdManager;
        private final SessionProvider sessionProvider;

        @Inject
        public Factory(State.Factory stateFactory, MessageIdManager messageIdManager, SessionProvider sessionProvider) {
            this.stateFactory = stateFactory;
            this.messageIdManager = messageIdManager;
            this.sessionProvider = sessionProvider;
        }

        public List<JmapChange> fromAdded(MailboxEvents.Added messageAdded, ZonedDateTime now, List<AccountId> sharees) {
            AccountId accountId = AccountId.fromUsername(messageAdded.getUsername());
            State state = this.stateFactory.generate();
            EmailChange ownerEmailChange = EmailChange.builder().accountId(accountId).state(state).date(now).isDelegated(false).isDelivery(messageAdded.isDelivery()).created((Collection<MessageId>)messageAdded.getMessageIds()).build();
            MailboxChange ownerMailboxChange = MailboxChange.builder().accountId(AccountId.fromUsername(messageAdded.getUsername())).state(state).date(now).isCountChange(true).delegated(false).updated((List<MailboxId>)ImmutableList.of((Object)messageAdded.getMailboxId())).build();
            MailboxAndEmailChange ownerChange = new MailboxAndEmailChange(accountId, ownerEmailChange, ownerMailboxChange);
            Stream<MailboxAndEmailChange> shareeChanges = sharees.stream().map(shareeId -> new MailboxAndEmailChange((AccountId)shareeId, EmailChange.builder().accountId((AccountId)shareeId).state(state).date(now).isDelegated(true).isDelivery(messageAdded.isDelivery()).created((Collection<MessageId>)messageAdded.getMessageIds()).build(), MailboxChange.builder().accountId((AccountId)shareeId).state(state).date(now).isCountChange(true).delegated(true).updated((List<MailboxId>)ImmutableList.of((Object)messageAdded.getMailboxId())).build()));
            return (List)Stream.concat(Stream.of(ownerChange), shareeChanges).collect(ImmutableList.toImmutableList());
        }

        public List<JmapChange> fromFlagsUpdated(MailboxEvents.FlagsUpdated messageFlagUpdated, ZonedDateTime now, List<AccountId> sharees) {
            boolean isSeenChanged = messageFlagUpdated.getUpdatedFlags().stream().anyMatch(flags -> flags.isChanged(Flags.Flag.SEEN));
            AccountId accountId = AccountId.fromUsername(messageFlagUpdated.getUsername());
            EmailChange ownerEmailChange = EmailChange.builder().accountId(accountId).state(this.stateFactory.generate()).date(now).isDelegated(false).updated(messageFlagUpdated.getMessageIds()).build();
            if (isSeenChanged) {
                MailboxChange ownerMailboxChange = MailboxChange.builder().accountId(AccountId.fromUsername(messageFlagUpdated.getUsername())).state(this.stateFactory.generate()).date(now).isCountChange(true).updated((List<MailboxId>)ImmutableList.of((Object)messageFlagUpdated.getMailboxId())).build();
                MailboxAndEmailChange ownerChange = new MailboxAndEmailChange(accountId, ownerEmailChange, ownerMailboxChange);
                Stream<MailboxAndEmailChange> shareeChanges = sharees.stream().map(shareeId -> new MailboxAndEmailChange((AccountId)shareeId, EmailChange.builder().accountId((AccountId)shareeId).state(this.stateFactory.generate()).date(now).isDelegated(true).updated(messageFlagUpdated.getMessageIds()).build(), MailboxChange.builder().accountId((AccountId)shareeId).state(this.stateFactory.generate()).date(now).isCountChange(true).delegated(true).updated((List<MailboxId>)ImmutableList.of((Object)messageFlagUpdated.getMailboxId())).delegated().build()));
                return (List)Stream.concat(Stream.of(ownerChange), shareeChanges).collect(ImmutableList.toImmutableList());
            }
            Stream<EmailChange> shareeChanges = sharees.stream().map(shareeId -> EmailChange.builder().accountId((AccountId)shareeId).state(this.stateFactory.generate()).date(now).isDelegated(true).updated(messageFlagUpdated.getMessageIds()).build());
            return (List)Stream.concat(Stream.of(ownerEmailChange), shareeChanges).collect(ImmutableList.toImmutableList());
        }

        public Flux<JmapChange> fromExpunged(MailboxEvents.Expunged expunged, ZonedDateTime now, List<Username> sharees) {
            State state = this.stateFactory.generate();
            boolean delegated = true;
            Mono<JmapChange> ownerChange = this.fromExpunged(expunged, now, expunged.getUsername(), state, !delegated);
            Flux shareeChanges = Flux.fromIterable(sharees).concatMap(shareeId -> this.fromExpunged(expunged, now, (Username)shareeId, state, delegated));
            return Flux.concat((Publisher[])new Publisher[]{ownerChange, shareeChanges});
        }

        private Mono<JmapChange> fromExpunged(MailboxEvents.Expunged expunged, ZonedDateTime now, Username username, State state, boolean delegated) {
            AccountId accountId = AccountId.fromUsername(username);
            MailboxChange mailboxChange = MailboxChange.builder().accountId(accountId).state(state).date(now).isCountChange(true).delegated(delegated).updated((List<MailboxId>)ImmutableList.of((Object)expunged.getMailboxId())).build();
            return Mono.from((Publisher)this.messageIdManager.accessibleMessagesReactive((Collection)expunged.getMessageIds(), this.sessionProvider.createSystemSession(username))).map(accessibleMessageIds -> new MailboxAndEmailChange(accountId, EmailChange.builder().accountId(AccountId.fromUsername(username)).state(state).date(now).isDelegated(delegated).updated((Collection<MessageId>)Sets.intersection((Set)ImmutableSet.copyOf((Collection)expunged.getMessageIds()), (Set)accessibleMessageIds)).destroyed((Collection<MessageId>)Sets.difference((Set)ImmutableSet.copyOf((Collection)expunged.getMessageIds()), (Set)accessibleMessageIds)).build(), mailboxChange)).switchIfEmpty(Mono.just((Object)mailboxChange));
        }
    }
}

