/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import org.apache.james.RunArguments;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.jmap.draft.JMAPDraftConfiguration;
import org.apache.james.lifecycle.api.ConfigurationSanitizer;
import org.apache.james.utils.KeystoreCreator;

public class JmapConfigurationSanitizer
implements ConfigurationSanitizer {
    private final JMAPDraftConfiguration jmapDraftConfiguration;
    private final KeystoreCreator keystoreCreator;
    private final FileSystem fileSystem;
    private final RunArguments runArguments;

    @Inject
    public JmapConfigurationSanitizer(JMAPDraftConfiguration jmapDraftConfiguration, KeystoreCreator keystoreCreator, FileSystem fileSystem, RunArguments runArguments) {
        this.jmapDraftConfiguration = jmapDraftConfiguration;
        this.keystoreCreator = keystoreCreator;
        this.fileSystem = fileSystem;
        this.runArguments = runArguments;
    }

    public void sanitize() throws Exception {
        if (this.jmapDraftConfiguration.isEnabled() && this.jmapDraftConfiguration.getKeystore().isPresent() && !this.keystoreExists() && this.runArguments.contain(RunArguments.Argument.GENERATE_KEYSTORE)) {
            this.keystoreCreator.generateKeystore((String)this.jmapDraftConfiguration.getKeystore().get(), (String)this.jmapDraftConfiguration.getSecret().orElseThrow(() -> new IllegalArgumentException("Can not auto-generate keystore as the keystore secret is missing from the configuration")), this.jmapDraftConfiguration.getKeystoreType());
        }
    }

    private boolean keystoreExists() {
        try {
            return this.fileSystem.getFile((String)this.jmapDraftConfiguration.getKeystore().get()).exists();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

