/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request;

import com.datastax.dse.protocol.internal.request.RawBytesQuery;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptionsCodec;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.Query;

public class DseQueryCodec
extends Query.Codec {
    public DseQueryCodec(int protocolVersion) {
        super(protocolVersion, new DseQueryOptionsCodec(protocolVersion));
        assert (protocolVersion >= 65);
    }

    @Override
    public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
        if (message instanceof RawBytesQuery) {
            RawBytesQuery query = (RawBytesQuery)message;
            encoder.writeBytes(query.query, dest);
            this.optionsCodec.encode(dest, query.options, encoder);
        } else {
            super.encode(dest, message, encoder);
        }
    }

    @Override
    public int encodedSize(Message message) {
        if (message instanceof RawBytesQuery) {
            RawBytesQuery query = (RawBytesQuery)message;
            return PrimitiveSizes.sizeOfBytes(query.query) + this.optionsCodec.encodedSize(query.options);
        }
        return super.encodedSize(message);
    }
}

