/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.time.Clock;
import java.util.Set;
import org.apache.james.backends.postgres.PostgresConfiguration;
import org.apache.james.backends.postgres.RowLevelSecurity;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.postgres.DeleteMessageListener;
import org.apache.james.mailbox.postgres.mail.PostgresAnnotationMapper;
import org.apache.james.mailbox.postgres.mail.PostgresAttachmentMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMailboxMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMailboxMemberDAO;
import org.apache.james.mailbox.postgres.mail.PostgresMessageIdMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMessageMapper;
import org.apache.james.mailbox.postgres.mail.PostgresModSeqProvider;
import org.apache.james.mailbox.postgres.mail.PostgresUidProvider;
import org.apache.james.mailbox.postgres.mail.RLSSupportPostgresMailboxMapper;
import org.apache.james.mailbox.postgres.mail.dao.PostgresAttachmentDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxAnnotationDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMessageDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresThreadDAO;
import org.apache.james.mailbox.postgres.user.PostgresSubscriptionDAO;
import org.apache.james.mailbox.postgres.user.PostgresSubscriptionMapper;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.mail.AnnotationMapper;
import org.apache.james.mailbox.store.mail.AttachmentIdAssignationStrategy;
import org.apache.james.mailbox.store.mail.AttachmentMapperFactory;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.user.SubscriptionMapper;

public class PostgresMailboxSessionMapperFactory
extends MailboxSessionMapperFactory
implements AttachmentMapperFactory {
    private final PostgresExecutor.Factory executorFactory;
    private final BlobStore blobStore;
    private final BlobId.Factory blobIdFactory;
    private final Clock clock;
    private final RowLevelSecurity rowLevelSecurity;
    private final AttachmentIdAssignationStrategy attachmentIdAssignationStrategy;

    @Inject
    public PostgresMailboxSessionMapperFactory(PostgresExecutor.Factory executorFactory, Clock clock, BlobStore blobStore, BlobId.Factory blobIdFactory, PostgresConfiguration postgresConfiguration, AttachmentIdAssignationStrategy attachmentIdAssignationStrategy) {
        this.executorFactory = executorFactory;
        this.blobStore = blobStore;
        this.blobIdFactory = blobIdFactory;
        this.clock = clock;
        this.rowLevelSecurity = postgresConfiguration.getRowLevelSecurity();
        this.attachmentIdAssignationStrategy = attachmentIdAssignationStrategy;
    }

    public MailboxMapper createMailboxMapper(MailboxSession session) {
        PostgresMailboxDAO mailboxDAO = new PostgresMailboxDAO(this.executorFactory.create(session.getUser().getDomainPart()));
        if (this.rowLevelSecurity.isRowLevelSecurityEnabled()) {
            return new RLSSupportPostgresMailboxMapper(mailboxDAO, new PostgresMailboxMemberDAO(this.executorFactory.create(session.getUser().getDomainPart())));
        }
        return new PostgresMailboxMapper(mailboxDAO);
    }

    public MessageMapper createMessageMapper(MailboxSession session) {
        return new PostgresMessageMapper(this.executorFactory.create(session.getUser().getDomainPart()), this.getModSeqProvider(session), this.getUidProvider(session), this.blobStore, this.clock, this.blobIdFactory, this.attachmentIdAssignationStrategy);
    }

    public MessageIdMapper createMessageIdMapper(MailboxSession session) {
        return new PostgresMessageIdMapper(new PostgresMailboxDAO(this.executorFactory.create(session.getUser().getDomainPart())), new PostgresMessageDAO(this.executorFactory.create(session.getUser().getDomainPart()), this.blobIdFactory), new PostgresMailboxMessageDAO(this.executorFactory.create(session.getUser().getDomainPart())), this.getModSeqProvider(session), this.getAttachmentMapper(session), this.blobStore, this.blobIdFactory, this.clock);
    }

    public SubscriptionMapper createSubscriptionMapper(MailboxSession session) {
        return new PostgresSubscriptionMapper(new PostgresSubscriptionDAO(this.executorFactory.create(session.getUser().getDomainPart())));
    }

    public AnnotationMapper createAnnotationMapper(MailboxSession session) {
        return new PostgresAnnotationMapper(new PostgresMailboxAnnotationDAO(this.executorFactory.create(session.getUser().getDomainPart())));
    }

    public PostgresUidProvider getUidProvider(MailboxSession session) {
        return new PostgresUidProvider.Factory(this.executorFactory).create(session);
    }

    public PostgresModSeqProvider getModSeqProvider(MailboxSession session) {
        return new PostgresModSeqProvider.Factory(this.executorFactory).create(session);
    }

    public PostgresAttachmentMapper createAttachmentMapper(MailboxSession session) {
        PostgresAttachmentDAO postgresAttachmentDAO = new PostgresAttachmentDAO(this.executorFactory.create(session.getUser().getDomainPart()), this.blobIdFactory);
        return new PostgresAttachmentMapper(postgresAttachmentDAO, this.blobStore, this.attachmentIdAssignationStrategy);
    }

    public PostgresAttachmentMapper getAttachmentMapper(MailboxSession session) {
        return this.createAttachmentMapper(session);
    }

    protected DeleteMessageListener deleteMessageListener() {
        PostgresMessageDAO.Factory postgresMessageDAOFactory = new PostgresMessageDAO.Factory(this.blobIdFactory, this.executorFactory);
        PostgresMailboxMessageDAO.Factory postgresMailboxMessageDAOFactory = new PostgresMailboxMessageDAO.Factory(this.executorFactory);
        PostgresAttachmentDAO.Factory attachmentDAOFactory = new PostgresAttachmentDAO.Factory(this.executorFactory, this.blobIdFactory);
        PostgresThreadDAO.Factory threadDAOFactory = new PostgresThreadDAO.Factory(this.executorFactory);
        return new DeleteMessageListener(this.blobStore, postgresMailboxMessageDAOFactory, postgresMessageDAOFactory, attachmentDAOFactory, threadDAOFactory, (Set<DeleteMessageListener.DeletionCallback>)ImmutableSet.of());
    }
}

