/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNotSupportedMixin;

public class TransactionalNotSupported
implements TransactionalNotSupportedMixin {
    public static Transactional create() {
        return new TransactionalNotSupported();
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    private static class Example
    implements Transactional {
        private final Transactional txn = new TransactionalNotSupported();

        private Example() {
        }

        private final Transactional txn() {
            return this.txn;
        }

        @Override
        public void begin() {
            this.txn().begin();
        }

        @Override
        public void begin(TxnType txnType) {
            this.txn().begin(txnType);
        }

        @Override
        public boolean promote(Transactional.Promote txnType) {
            return this.txn().promote(txnType);
        }

        @Override
        public void commit() {
            this.txn().commit();
        }

        @Override
        public void abort() {
            this.txn().abort();
        }

        @Override
        public boolean isInTransaction() {
            return this.txn().isInTransaction();
        }

        @Override
        public void end() {
            this.txn().end();
        }

        @Override
        public ReadWrite transactionMode() {
            return this.txn().transactionMode();
        }

        @Override
        public TxnType transactionType() {
            return this.txn().transactionType();
        }
    }
}

