/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.jdom2.Element;

public class MarkupHelper {
    public static void printUnescaped(PrintWriter out, String s) {
        out.print(StringEscapeUtils.unescapeHtml4((String)s));
    }

    public static boolean isFootnoteLink(String ref) {
        return ref.startsWith("#ref-");
    }

    public static boolean isUndefinedPageLink(Element a) {
        String classVal = a.getAttributeValue("class");
        return "createpage".equals(classVal);
    }

    public static boolean isHtmlBaseDiv(XHtmlElementToWikiTranslator.ElementDecoratorData dto) {
        return "div".equals(dto.htmlBase);
    }

    public static boolean isHtmlBaseSpan(XHtmlElementToWikiTranslator.ElementDecoratorData dto) {
        return "span".equals(dto.htmlBase);
    }

    public static Map<String, String> getAugmentedWikiLinkAttributes(Element a) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        String cssClass = a.getAttributeValue("class");
        if (StringUtils.isNotEmpty((CharSequence)cssClass) && !cssClass.matches("wikipage|createpage|external|interwiki|attachment")) {
            attributesMap.put("class", cssClass.replace("'", "\""));
        }
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "accesskey");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "charset");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "dir");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "hreflang");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "id");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "lang");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "rel");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "rev");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "style");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "tabindex");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "target");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "title");
        MarkupHelper.addAttributeIfPresent(a, attributesMap, "type");
        return attributesMap;
    }

    static void addAttributeIfPresent(Element a, Map<String, String> attributesMap, String attribute) {
        String attr = a.getAttributeValue(attribute);
        if (StringUtils.isNotEmpty((CharSequence)attr)) {
            attributesMap.put(attribute, attr.replace("'", "\""));
        }
    }

    public static String augmentedWikiLinkMapToString(Map<String, String> attributesMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            String attributeName = entry.getKey();
            String attributeValue = entry.getValue();
            sb.append(" ").append(attributeName).append("='").append(attributeValue).append("'");
        }
        return sb.toString().trim();
    }

    public static String nameSansNbf(Element e) {
        String name = e.getAttributeValue("name");
        if (name != null && name.startsWith("nbf_")) {
            return name.substring(4);
        }
        return name;
    }
}

