/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.util.TextUtil;

public final class PropertyReader {
    private static final Logger LOG = LogManager.getLogger(PropertyReader.class);
    public static final String DEFAULT_JSPWIKI_CONFIG = "/ini/jspwiki.properties";
    public static final String PARAM_CUSTOMCONFIG = "jspwiki.custom.config";
    public static final String PARAM_CUSTOMCONFIG_CASCADEPREFIX = "jspwiki.custom.cascade.";
    public static final String CUSTOM_JSPWIKI_CONFIG = "/jspwiki-custom.properties";
    private static final String PARAM_VAR_DECLARATION = "var.";
    private static final String PARAM_VAR_IDENTIFIER = "$";

    private PropertyReader() {
    }

    public static Properties loadWebAppProps(ServletContext context) {
        Properties properties;
        block10: {
            String propertyFile = PropertyReader.getInitParameter(context, PARAM_CUSTOMCONFIG);
            InputStream propertyStream = PropertyReader.loadCustomPropertiesFile(context, propertyFile);
            try {
                Properties props = PropertyReader.getDefaultProperties();
                Map<String, String> env = PropertyReader.collectPropertiesFrom(System.getenv());
                props.putAll(env);
                if (propertyStream == null) {
                    LOG.debug("No custom property file found, relying on JSPWiki defaults.");
                } else {
                    props.load(propertyStream);
                }
                LOG.debug("Loading cascading properties...");
                PropertyReader.loadWebAppPropsCascade(context, props);
                PropertyReader.propertyExpansion(props);
                PropertyReader.setWorkDir(context, props);
                Map<String, String> sysprops = PropertyReader.collectPropertiesFrom(System.getProperties().entrySet().stream().collect(Collectors.toMap(Object::toString, Object::toString)));
                props.putAll(sysprops);
                PropertyReader.expandVars(props);
                properties = props;
                if (propertyStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (propertyStream != null) {
                        try {
                            propertyStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            propertyStream.close();
        }
        return properties;
    }

    static Map<String, String> collectPropertiesFrom(Map<String, String> map) {
        return map.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().startsWith("jspwiki")).map(entry -> new AbstractMap.SimpleEntry<String, String>(((String)entry.getKey()).replace("_", "."), (String)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static InputStream loadCustomPropertiesFile(ServletContext context, String propertyFile) throws IOException {
        InputStream propertyStream;
        if (propertyFile == null) {
            LOG.debug("No jspwiki.custom.config defined for this context, looking for custom properties file with default name of: /jspwiki-custom.properties");
            propertyStream = PropertyReader.locateClassPathResource(context, CUSTOM_JSPWIKI_CONFIG);
        } else {
            LOG.debug("jspwiki.custom.config defined, using " + propertyFile + " as the custom properties file.");
            propertyStream = Files.newInputStream(new File(propertyFile).toPath(), new OpenOption[0]);
        }
        return propertyStream;
    }

    public static Properties getDefaultProperties() {
        Properties props = new Properties();
        try (InputStream in = PropertyReader.class.getResourceAsStream(DEFAULT_JSPWIKI_CONFIG);){
            if (in != null) {
                props.load(in);
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load default propertyfile '{}' {}", (Object)DEFAULT_JSPWIKI_CONFIG, (Object)e.getMessage(), (Object)e);
        }
        return props;
    }

    public static Properties getCombinedProperties(String fileName) {
        Properties newPropertySet = PropertyReader.getDefaultProperties();
        try (InputStream in = PropertyReader.class.getResourceAsStream(fileName);){
            if (in != null) {
                newPropertySet.load(in);
            } else {
                LOG.error("*** Custom property file \"" + fileName + "\" not found, relying on default file alone.");
            }
        }
        catch (IOException e) {
            LOG.error("Unable to load propertyfile '" + fileName + "'" + e.getMessage(), (Throwable)e);
        }
        return newPropertySet;
    }

    private static String getInitParameter(ServletContext context, String name) {
        String value = context.getInitParameter(name);
        return value != null ? value : System.getProperty(name);
    }

    private static void loadWebAppPropsCascade(ServletContext context, Properties defaultProperties) {
        String propertyFile;
        if (PropertyReader.getInitParameter(context, "jspwiki.custom.cascade.1") == null) {
            LOG.debug(" No cascading properties defined for this context");
            return;
        }
        int depth = 0;
        while ((propertyFile = PropertyReader.getInitParameter(context, PARAM_CUSTOMCONFIG_CASCADEPREFIX + ++depth)) != null) {
            try {
                InputStream propertyStream = Files.newInputStream(Paths.get(propertyFile, new String[0]), new OpenOption[0]);
                try {
                    LOG.info(" Reading additional properties from {} and merge to cascade.", (Object)propertyFile);
                    Properties additionalProps = new Properties();
                    additionalProps.load(propertyStream);
                    defaultProperties.putAll((Map<?, ?>)additionalProps);
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
            catch (Exception e) {
                LOG.error("JSPWiki: Unable to load and setup properties from {}. {}", (Object)propertyFile, (Object)e.getMessage());
            }
        }
    }

    public static void propertyExpansion(Properties properties) {
        Enumeration<?> propertyList = properties.propertyNames();
        block0: while (propertyList.hasMoreElements()) {
            String propertyName = (String)propertyList.nextElement();
            String propertyValue = properties.getProperty(propertyName);
            while (propertyValue.contains("${") && propertyValue.contains("}")) {
                int start = propertyValue.indexOf("${");
                int end = propertyValue.indexOf("}", start);
                if (start < 0 || end < 0 || end <= start) continue block0;
                String substring = propertyValue.substring(start, end).replace("${", "").replace("}", "");
                String expansion = Objects.toString(System.getProperty(substring), System.getenv(substring));
                if (expansion != null) {
                    propertyValue = propertyValue.replace("${" + substring + "}", expansion);
                    properties.setProperty(propertyName, propertyValue);
                    continue;
                }
                LOG.warn("{} referenced on {} ({}) but not found on System props or env", (Object)substring, (Object)propertyName, (Object)propertyValue);
                continue block0;
            }
        }
    }

    public static void expandVars(Properties properties) {
        String propertyValue;
        String propertyName;
        HashMap<String, String> vars = new HashMap<String, String>();
        Enumeration<?> propertyList = properties.propertyNames();
        while (propertyList.hasMoreElements()) {
            propertyName = (String)propertyList.nextElement();
            propertyValue = properties.getProperty(propertyName);
            if (!propertyName.startsWith(PARAM_VAR_DECLARATION)) continue;
            String varName = propertyName.substring(4).trim();
            String varValue = propertyValue.trim();
            vars.put(varName, varValue);
        }
        propertyList = properties.propertyNames();
        while (propertyList.hasMoreElements()) {
            propertyName = (String)propertyList.nextElement();
            propertyValue = properties.getProperty(propertyName);
            if (propertyName.startsWith(PARAM_VAR_DECLARATION)) continue;
            for (Map.Entry entry : vars.entrySet()) {
                String varName = (String)entry.getKey();
                String varValue = (String)entry.getValue();
                propertyValue = TextUtil.replaceString(propertyValue, PARAM_VAR_IDENTIFIER + varName, varValue);
                properties.put(propertyName, propertyValue);
            }
        }
    }

    public static InputStream locateClassPathResource(ServletContext context, String resourceName) {
        if (StringUtils.isEmpty((CharSequence)resourceName)) {
            return null;
        }
        String currResourceLocation = PropertyReader.createResourceLocation("/WEB-INF/classes", resourceName);
        InputStream result = context.getResourceAsStream(currResourceLocation);
        if (result != null) {
            LOG.debug(" Successfully located the following classpath resource : " + currResourceLocation);
            return result;
        }
        currResourceLocation = PropertyReader.createResourceLocation("", resourceName);
        result = PropertyReader.class.getResourceAsStream(currResourceLocation);
        if (result != null) {
            LOG.debug(" Successfully located the following classpath resource : " + currResourceLocation);
            return result;
        }
        LOG.debug(" Unable to resolve the following classpath resource : " + resourceName);
        return result;
    }

    static String createResourceLocation(String path, String name) {
        String sanitizedName;
        Validate.notEmpty((CharSequence)name, (String)"name is empty", (Object[])new Object[0]);
        StringBuilder result = new StringBuilder();
        String sanitizedPath = path != null && !path.isEmpty() && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        String string = sanitizedName = name.startsWith("/") ? name.substring(1) : name;
        if (sanitizedPath != null && !sanitizedPath.isEmpty()) {
            if (!sanitizedPath.startsWith("/")) {
                result.append("/");
            }
            result.append(sanitizedPath);
        }
        result.append("/");
        result.append(sanitizedName);
        return result.toString();
    }

    static void setWorkDir(ServletContext servletContext, Properties properties) {
        String workDir = TextUtil.getStringProperty(properties, "jspwiki.workDir", null);
        if (workDir == null) {
            File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (tempDir != null) {
                properties.setProperty("jspwiki.workDir", tempDir.getAbsolutePath());
                LOG.info("Setting jspwiki.workDir to ServletContext's temporary directory: {}", (Object)tempDir.getAbsolutePath());
            } else {
                String defaultTmpDir = System.getProperty("java.io.tmpdir");
                properties.setProperty("jspwiki.workDir", defaultTmpDir);
                LOG.info("ServletContext's temporary directory not found. Setting jspwiki.workDir to system's temporary directory: {}", (Object)defaultTmpDir);
            }
        } else {
            LOG.info("jspwiki.workDir is already set to: {}", (Object)workDir);
        }
    }
}

