/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.jetty;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.config.Config;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.SystemUtils;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.MicroserviceBuilder;
import org.apache.juneau.microservice.jetty.BasicJettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.BasicJettyServerFactory;
import org.apache.juneau.microservice.jetty.JettyMicroserviceBuilder;
import org.apache.juneau.microservice.jetty.JettyMicroserviceListener;
import org.apache.juneau.microservice.jetty.JettyServerFactory;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.utils.ManifestFile;
import org.apache.juneau.utils.MessageBundle;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class JettyMicroservice
extends Microservice {
    private static volatile JettyMicroservice INSTANCE;
    final MessageBundle messages = MessageBundle.create(JettyMicroservice.class);
    private final JettyMicroserviceBuilder builder;
    final JettyMicroserviceListener listener;
    private final JettyServerFactory factory;
    volatile Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(JettyMicroservice m) {
        Class<JettyMicroservice> clazz = JettyMicroservice.class;
        synchronized (JettyMicroservice.class) {
            INSTANCE = m;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JettyMicroservice getInstance() {
        Class<JettyMicroservice> clazz = JettyMicroservice.class;
        synchronized (JettyMicroservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] args) throws Exception {
        JettyMicroservice.create().args(args).build().start().startConsole().join();
    }

    public static JettyMicroserviceBuilder create() {
        return new JettyMicroserviceBuilder();
    }

    protected JettyMicroservice(JettyMicroserviceBuilder builder) throws ParseException, IOException {
        super((MicroserviceBuilder)builder);
        JettyMicroservice.setInstance(this);
        this.builder = builder.copy();
        this.listener = builder.listener != null ? builder.listener : new BasicJettyMicroserviceListener();
        this.factory = builder.factory != null ? builder.factory : new BasicJettyServerFactory();
    }

    public synchronized JettyMicroservice init() throws ParseException, IOException {
        super.init();
        return this;
    }

    public synchronized JettyMicroservice startConsole() throws Exception {
        super.startConsole();
        return this;
    }

    public synchronized JettyMicroservice stopConsole() throws Exception {
        super.stopConsole();
        return this;
    }

    public synchronized JettyMicroservice start() throws Exception {
        super.start();
        this.createServer();
        this.startServer();
        return this;
    }

    public JettyMicroservice join() throws Exception {
        this.server.join();
        return this;
    }

    public synchronized JettyMicroservice stop() throws Exception {
        final Logger logger = this.getLogger();
        final MessageBundle mb2 = this.messages;
        Thread t = new Thread("JettyMicroserviceStop"){

            @Override
            public void run() {
                try {
                    if (JettyMicroservice.this.server == null || JettyMicroservice.this.server.isStopping() || JettyMicroservice.this.server.isStopped()) {
                        return;
                    }
                    JettyMicroservice.this.listener.onStopServer(JettyMicroservice.this);
                    JettyMicroservice.this.out(mb2, "StoppingServer", new Object[0]);
                    JettyMicroservice.this.server.stop();
                    JettyMicroservice.this.out(mb2, "ServerStopped", new Object[0]);
                    JettyMicroservice.this.listener.onPostStopServer(JettyMicroservice.this);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.stop();
        return this;
    }

    public int getPort() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            return ((ServerConnector)c).getPort();
        }
        throw new RuntimeException("Could not locate ServerConnector in Jetty server.");
    }

    public String getContextPath() {
        for (Handler h : this.getServer().getHandlers()) {
            if (h instanceof HandlerCollection) {
                for (Handler h2 : ((HandlerCollection)h).getChildHandlers()) {
                    if (!(h2 instanceof ServletContextHandler)) continue;
                    return ((ServletContextHandler)h2).getContextPath();
                }
            }
            if (!(h instanceof ServletContextHandler)) continue;
            return ((ServletContextHandler)h).getContextPath();
        }
        throw new RuntimeException("Could not locate ServletContextHandler in Jetty server.");
    }

    public String getProtocol() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            for (ConnectionFactory cf : ((ServerConnector)c).getConnectionFactories()) {
                if (!(cf instanceof SslConnectionFactory)) continue;
                return "https";
            }
        }
        return "http";
    }

    public String getHostName() {
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public URI getURI() {
        String cp = this.getContextPath();
        try {
            return new URI(this.getProtocol(), null, this.getHostName(), this.getPort(), "/".equals(cp) ? null : cp, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Server createServer() throws ParseException, IOException, ExecutableException {
        this.listener.onCreateServer(this);
        Config cf = this.getConfig();
        ManifestFile mf = this.getManifest();
        VarResolver vr = this.getVarResolver();
        int[] ports = (int[])ObjectUtils.firstNonNull((Object[])new int[][]{this.builder.ports, (int[])cf.getObjectWithDefault("Jetty/port", (Object)((int[])mf.getWithDefault("Jetty-Port", (Object)new int[]{8000}, int[].class)), int[].class)});
        int availablePort = JettyMicroservice.findOpenPort(ports);
        SystemUtils.setProperty((String)"availablePort", (Object)availablePort, (boolean)false);
        String jettyXml = this.builder.jettyXml;
        String jettyConfig = cf.getString("Jetty/config", mf.getString("Jetty-Config", "jetty.xml"));
        boolean resolveVars = (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{this.builder.jettyXmlResolveVars, cf.getBoolean("Jetty/resolveVars")});
        if (jettyXml == null) {
            jettyXml = IOUtils.loadSystemResourceAsString((String)"jetty.xml", (String[])new String[]{".", "files"});
        }
        if (jettyXml == null) {
            throw new FormattedRuntimeException("jetty.xml file ''{0}'' was not found on the file system or classpath.", new Object[]{jettyConfig});
        }
        if (resolveVars) {
            jettyXml = vr.resolve(jettyXml);
        }
        this.getLogger().info(jettyXml);
        try {
            this.server = this.factory.create(jettyXml);
        }
        catch (Exception e2) {
            throw new ExecutableException((Throwable)e2);
        }
        for (String s : cf.getStringArray("Jetty/servlets", new String[0])) {
            try {
                ClassInfo c = ClassInfo.of(Class.forName(s));
                if (!c.isChildOf(RestServlet.class)) {
                    throw new FormattedRuntimeException("Invalid servlet specified in Jetty/servlets.  Must be a subclass of RestServlet.", new Object[]{s});
                }
                RestServlet rs = (RestServlet)c.newInstance();
                this.addServlet((Servlet)rs, rs.getPath());
            }
            catch (ClassNotFoundException e1) {
                throw new ExecutableException((Throwable)e1);
            }
        }
        for (Map.Entry entry : cf.getObjectMap("Jetty/servletMap", ObjectMap.EMPTY_MAP).entrySet()) {
            try {
                ClassInfo c = ClassInfo.of(Class.forName(entry.getValue().toString()));
                if (c.isChildOf(Servlet.class)) {
                    Servlet rs = (Servlet)c.newInstance();
                    this.addServlet(rs, (String)entry.getKey());
                    continue;
                }
                throw new FormattedRuntimeException("Invalid servlet specified in Jetty/servletMap.  Must be a subclass of Servlet.", new Object[]{entry.getValue()});
            }
            catch (ClassNotFoundException e1) {
                throw new ExecutableException((Throwable)e1);
            }
        }
        for (Map.Entry entry : cf.getObjectMap("Jetty/servletAttributes", ObjectMap.EMPTY_MAP).entrySet()) {
            this.addServletAttribute((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.builder.servlets.entrySet()) {
            this.addServlet((Servlet)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry entry : this.builder.servletAttributes.entrySet()) {
            this.addServletAttribute((String)entry.getKey(), entry.getValue());
        }
        SystemUtils.setProperty((String)"juneau.serverPort", (Object)availablePort, (boolean)false);
        return this.server;
    }

    public void destroyServer() throws Exception {
        if (this.server != null) {
            this.server.destroy();
        }
        this.server = null;
    }

    public JettyMicroservice addServlet(Servlet servlet, String pathSpec) {
        ServletHolder sh = new ServletHolder(servlet);
        if (pathSpec != null && !pathSpec.endsWith("/*")) {
            pathSpec = StringUtils.trimTrailingSlashes((String)pathSpec) + "/*";
        }
        this.getServletContextHandler().addServlet(sh, pathSpec);
        return this;
    }

    protected ServletContextHandler getServletContextHandler() {
        for (Handler h : this.getServer().getHandlers()) {
            ServletContextHandler sch = JettyMicroservice.getServletContextHandler(h);
            if (sch == null) continue;
            return sch;
        }
        throw new RuntimeException("Servlet context handler not found in jetty server.");
    }

    public JettyMicroservice addServletAttribute(String name, Object value) {
        this.getServer().setAttribute(name, value);
        return this;
    }

    public Server getServer() {
        if (this.server == null) {
            throw new RuntimeException("Server not found.  createServer() must be called first.");
        }
        return this.server;
    }

    protected int startServer() throws Exception {
        this.listener.onStartServer(this);
        this.server.start();
        this.out(this.messages, "ServerStarted", new Object[]{this.getPort()});
        this.listener.onPostStartServer(this);
        return this.getPort();
    }

    private static ServletContextHandler getServletContextHandler(Handler h) {
        if (h instanceof ServletContextHandler) {
            return (ServletContextHandler)h;
        }
        if (h instanceof HandlerCollection) {
            for (Handler h2 : ((HandlerCollection)h).getHandlers()) {
                ServletContextHandler sch = JettyMicroservice.getServletContextHandler(h2);
                if (sch == null) continue;
                return sch;
            }
        }
        return null;
    }

    private static int findOpenPort(int[] ports) {
        int[] nArray = ports;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int port = nArray[n2];
            if (port == 0) {
                port = new Random().nextInt(Short.MAX_VALUE - ports[0] + 1) + ports[0];
            }
            ServerSocket ss = new ServerSocket(port);
            try {
                n3 = port;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ss.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    ++n2;
                }
            }
            ss.close();
            return n3;
        }
        return 0;
    }
}

