/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.Version;
import org.apache.juneau.assertions.FluentVersionAssertion;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicStringHeader;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;

@Header(value="Client-Version")
public class ClientVersion
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Client-Version";
    private static final Cache<String, ClientVersion> CACHE = Cache.of(String.class, ClientVersion.class).build();
    private final Version value;
    private final Supplier<Version> supplier;

    public static ClientVersion of(String value) {
        return value == null ? null : CACHE.get(value, () -> new ClientVersion(value));
    }

    public static ClientVersion of(Version value) {
        return value == null ? null : new ClientVersion(value);
    }

    public static ClientVersion of(Supplier<Version> value) {
        return value == null ? null : new ClientVersion(value);
    }

    public ClientVersion(String value) {
        super(NAME, value);
        this.value = Version.of(value);
        this.supplier = null;
    }

    public ClientVersion(Version value) {
        super(NAME, StringUtils.stringify(value));
        this.value = value;
        this.supplier = null;
    }

    public ClientVersion(Supplier<Version> value) {
        super(NAME, (String)null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        if (this.supplier != null) {
            return StringUtils.stringify(this.supplier.get());
        }
        return super.getValue();
    }

    public Optional<Version> asVersion() {
        return CollectionUtils.optional(this.value);
    }

    public FluentVersionAssertion<ClientVersion> assertVersion() {
        return new FluentVersionAssertion<ClientVersion>(this.asVersion().orElse(null), this);
    }
}

