/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;

public class BeanCreateMethodFinder<T> {
    private Class<T> beanType;
    private final Class<?> resourceClass;
    private final Object resource;
    private final BeanStore beanStore;
    private MethodInfo method;
    private Object[] args;
    private Supplier<T> def = () -> null;

    BeanCreateMethodFinder(Class<T> beanType, Object resource, BeanStore beanStore) {
        this.beanType = Assertions.assertArgNotNull("beanType", beanType);
        this.resource = Assertions.assertArgNotNull("resource", resource);
        this.resourceClass = resource.getClass();
        this.beanStore = BeanStore.of(beanStore, resource);
    }

    BeanCreateMethodFinder(Class<T> beanType, Class<?> resourceClass, BeanStore beanStore) {
        this.beanType = Assertions.assertArgNotNull("beanType", beanType);
        this.resource = null;
        this.resourceClass = Assertions.assertArgNotNull("resourceClass", resourceClass);
        this.beanStore = BeanStore.of(beanStore);
    }

    public <T2> BeanCreateMethodFinder<T> addBean(Class<T2> c, T2 t) {
        this.beanStore.addBean(c, t);
        return this;
    }

    public BeanCreateMethodFinder<T> find(String methodName, Class<?> ... requiredParams) {
        if (this.method == null) {
            this.method = ClassInfo.of(this.resourceClass).getPublicMethod(x -> x.isNotDeprecated() && x.hasReturnType(this.beanType) && x.hasName(methodName) && x.hasNoAnnotation(BeanIgnore.class) && x.hasAllArgs(requiredParams) && this.beanStore.hasAllParams((ExecutableInfo)x) && (x.isStatic() || this.resource != null));
            if (this.method != null) {
                this.args = this.beanStore.getParams(this.method);
            }
        }
        return this;
    }

    public BeanCreateMethodFinder<T> thenFind(String methodName, Class<?> ... requiredParams) {
        return this.find(methodName, requiredParams);
    }

    public BeanCreateMethodFinder<T> withDefault(T def) {
        return this.withDefault(() -> def);
    }

    public BeanCreateMethodFinder<T> withDefault(Supplier<T> def) {
        Assertions.assertArgNotNull("def", def);
        this.def = def;
        return this;
    }

    public T run() throws ExecutableException {
        if (this.method != null) {
            return this.method.invoke(this.resource, this.args);
        }
        return this.def.get();
    }

    public T run(Consumer<? super T> consumer) throws ExecutableException {
        T t = this.run();
        if (t != null) {
            consumer.accept(t);
        }
        return t;
    }
}

