/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanFilter;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.Value;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.Beanc;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.annotation.Name;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.IntValue;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.FieldInfo;
import org.apache.juneau.reflect.MethodInfo;

public class BeanMeta<T> {
    private static final BeanPropertyMeta[] EMPTY_PROPERTIES = new BeanPropertyMeta[0];
    protected final ClassMeta<T> classMeta;
    protected final Class<T> c;
    protected final Map<String, BeanPropertyMeta> properties;
    protected final BeanPropertyMeta[] propertyArray;
    protected final Map<String, BeanPropertyMeta> hiddenProperties;
    protected final Map<Method, String> getterProps;
    protected final Map<Method, String> setterProps;
    protected final BeanContext ctx;
    protected final BeanFilter beanFilter;
    protected final Map<Class<?>, Class<?>[]> typeVarImpls;
    protected final ConstructorInfo constructor;
    protected final String[] constructorArgs;
    final String typePropertyName;
    private final BeanPropertyMeta typeProperty;
    final BeanPropertyMeta dynaProperty;
    private final String dictionaryName;
    final String notABeanReason;
    final BeanRegistry beanRegistry;
    final boolean sortProperties;
    final boolean fluentSetters;

    protected BeanMeta(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames, ConstructorInfo implClassConstructor) {
        this.classMeta = classMeta;
        this.ctx = ctx;
        this.c = classMeta.getInnerClass();
        Builder<T> b = new Builder<T>(classMeta, ctx, beanFilter, pNames, implClassConstructor);
        this.notABeanReason = b.init(this);
        this.beanFilter = beanFilter;
        this.dictionaryName = b.dictionaryName;
        this.properties = CollectionUtils.unmodifiable(b.properties);
        this.propertyArray = this.properties == null ? EMPTY_PROPERTIES : CollectionUtils.array(this.properties.values(), BeanPropertyMeta.class);
        this.hiddenProperties = CollectionUtils.unmodifiable(b.hiddenProperties);
        this.getterProps = CollectionUtils.unmodifiable(b.getterProps);
        this.setterProps = CollectionUtils.unmodifiable(b.setterProps);
        this.dynaProperty = b.dynaProperty;
        this.typeVarImpls = CollectionUtils.unmodifiable(b.typeVarImpls);
        this.constructor = b.constructor;
        this.constructorArgs = b.constructorArgs;
        this.beanRegistry = b.beanRegistry;
        this.typePropertyName = b.typePropertyName;
        this.typeProperty = BeanPropertyMeta.builder(this, this.typePropertyName).canRead().canWrite().rawMetaType(ctx.string()).beanRegistry(this.beanRegistry).build();
        this.sortProperties = b.sortProperties;
        this.fluentSetters = b.fluentSetters;
        if (this.sortProperties) {
            Arrays.sort(this.propertyArray);
        }
    }

    public final ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public final String getDictionaryName() {
        return this.dictionaryName;
    }

    public final BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    static final List<BeanMethod> findBeanMethods(BeanContext ctx, Class<?> c, Class<?> stopClass, Visibility v, PropertyNamer pn, boolean fluentSetters) {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        BeanMeta.forEachClass(ClassInfo.of(c), stopClass, c2 -> {
            for (MethodInfo m : c2.getDeclaredMethods()) {
                Transient t;
                if (m.isStatic() || m.isBridge() || m.getParamCount() > 2 || m.hasAnnotation(ctx, BeanIgnore.class) || (t = m.getAnnotation(ctx, Transient.class)) != null && t.value()) continue;
                ArrayList<Beanp> lp = CollectionUtils.list(new Beanp[0]);
                ArrayList<Name> ln = CollectionUtils.list(new Name[0]);
                ctx.forEachAnnotation(Beanp.class, m.inner(), x -> true, x -> lp.add((Beanp)x));
                ctx.forEachAnnotation(Name.class, m.inner(), x -> true, x -> ln.add((Name)x));
                if (!m.isVisible(v) && lp.size() <= 0 && ln.size() <= 0) continue;
                String n = m.getSimpleName();
                List<ClassInfo> pt = m.getParamTypes();
                ClassInfo rt = m.getReturnType();
                MethodType methodType = MethodType.UNKNOWN;
                String bpName = BeanMeta.bpName(lp, ln);
                if (pt.size() == 0) {
                    if ("*".equals(bpName)) {
                        if (rt.isChildOf(Collection.class)) {
                            methodType = MethodType.EXTRAKEYS;
                        } else if (rt.isChildOf(Map.class)) {
                            methodType = MethodType.GETTER;
                        }
                        n = bpName;
                    } else if (n.startsWith("get") && !rt.is(Void.TYPE)) {
                        methodType = MethodType.GETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("is") && (rt.is(Boolean.TYPE) || rt.is(Boolean.class))) {
                        methodType = MethodType.GETTER;
                        n = n.substring(2);
                    } else if (bpName != null) {
                        methodType = MethodType.GETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("get")) {
                                n = n.substring(3);
                            } else if (n.startsWith("is")) {
                                n = n.substring(2);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    }
                } else if (pt.size() == 1) {
                    if ("*".equals(bpName)) {
                        if (pt.get(0).isChildOf(Map.class)) {
                            methodType = MethodType.SETTER;
                            n = bpName;
                        } else if (pt.get(0).is(String.class)) {
                            methodType = MethodType.GETTER;
                            n = bpName;
                        }
                    } else if (n.startsWith("set") && (rt.isParentOf(c) || rt.is(Void.TYPE))) {
                        methodType = MethodType.SETTER;
                        n = n.substring(3);
                    } else if (n.startsWith("with") && rt.isParentOf(c)) {
                        methodType = MethodType.SETTER;
                        n = n.substring(4);
                    } else if (bpName != null) {
                        methodType = MethodType.SETTER;
                        if (bpName.isEmpty()) {
                            if (n.startsWith("set")) {
                                n = n.substring(3);
                            }
                            bpName = n;
                        } else {
                            n = bpName;
                        }
                    } else if (fluentSetters && rt.isParentOf(c)) {
                        methodType = MethodType.SETTER;
                    }
                } else if (pt.size() == 2 && "*".equals(bpName) && pt.get(0).is(String.class)) {
                    methodType = n.startsWith("set") && (rt.isParentOf(c) || rt.is(Void.TYPE)) ? MethodType.SETTER : MethodType.GETTER;
                    n = bpName;
                }
                n = pn.getPropertyName(n);
                if ("*".equals(bpName) && methodType == MethodType.UNKNOWN) {
                    throw new BeanRuntimeException(c, "Found @Beanp(\"*\") but could not determine method type on method ''{0}''.", m.getSimpleName());
                }
                if (methodType == MethodType.UNKNOWN) continue;
                if (bpName != null && !bpName.isEmpty()) {
                    n = bpName;
                }
                if (n == null) continue;
                l.add(new BeanMethod(n, methodType, m.inner()));
            }
        });
        return l;
    }

    static final Collection<Field> findBeanFields(BeanContext ctx, Class<?> c, Class<?> stopClass, Visibility v) {
        LinkedList<Field> l = new LinkedList<Field>();
        boolean noIgnoreTransients = !ctx.isIgnoreTransientFields();
        BeanMeta.forEachClass(ClassInfo.of(c), stopClass, c2 -> c2.forEachDeclaredField(x -> !(!x.isNotStatic() || !x.isNotTransient() && !noIgnoreTransients || !x.hasNoAnnotation(Transient.class) && !noIgnoreTransients || !x.hasNoAnnotation(ctx, BeanIgnore.class) || !v.isVisible(x.inner()) && !x.hasAnnotation(ctx, Beanp.class)), x -> l.add(x.inner())));
        return l;
    }

    static final Field findInnerBeanField(BeanContext ctx, Class<?> c, Class<?> stopClass, String name) {
        boolean noIgnoreTransients = !ctx.isIgnoreTransientFields();
        Value value = Value.empty();
        BeanMeta.forEachClass(ClassInfo.of(c), stopClass, c2 -> {
            FieldInfo f = c2.getDeclaredField(x -> !(!x.isNotStatic() || !x.isNotTransient() && !noIgnoreTransients || !x.hasNoAnnotation(Transient.class) && !noIgnoreTransients || !x.hasNoAnnotation(ctx, BeanIgnore.class) || !x.hasName(name)));
            if (f != null) {
                value.set(f.inner());
            }
        });
        return (Field)value.get();
    }

    private static void forEachClass(ClassInfo c, Class<?> stopClass, Consumer<ClassInfo> consumer) {
        ClassInfo sc = c.getSuperclass();
        if (sc != null && !sc.is(stopClass)) {
            BeanMeta.forEachClass(sc, stopClass, consumer);
        }
        c.getInterfaces().forEach(x -> BeanMeta.forEachClass(x, stopClass, consumer));
        consumer.accept(c);
    }

    public Collection<BeanPropertyMeta> getPropertyMetas() {
        return CollectionUtils.ulist(this.propertyArray);
    }

    public void forEachProperty(Predicate<BeanPropertyMeta> filter, Consumer<BeanPropertyMeta> action) {
        for (BeanPropertyMeta x : this.propertyArray) {
            if (!ConsumerUtils.test(filter, x)) continue;
            action.accept(x);
        }
    }

    public <T2> Optional<T2> firstProperty(Predicate<BeanPropertyMeta> filter, Function<BeanPropertyMeta, T2> function) {
        for (BeanPropertyMeta x : this.propertyArray) {
            if (!ConsumerUtils.test(filter, x)) continue;
            return Optional.ofNullable(function.apply(x));
        }
        return Optional.empty();
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        BeanPropertyMeta bpm = this.properties.get(name);
        if (bpm == null) {
            bpm = this.hiddenProperties.get(name);
        }
        if (bpm == null) {
            bpm = this.dynaProperty;
        }
        return bpm;
    }

    protected T newBean(Object outer) throws ExecutableException {
        if (this.classMeta.isMemberClass()) {
            if (this.constructor != null) {
                return this.constructor.invoke(outer);
            }
        } else {
            if (this.constructor != null) {
                return this.constructor.invoke(new Object[0]);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (h != null) {
                ClassLoader cl = this.classMeta.innerClass.getClassLoader();
                return (T)Proxy.newProxyInstance(cl, new Class[]{this.classMeta.innerClass, Serializable.class}, h);
            }
        }
        return null;
    }

    static final void findTypeVarImpls(Type t, Map<Class<?>, Class<?>[]> m) {
        ParameterizedType pt;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            BeanMeta.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                BeanMeta.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
            Type[] gImpls = pt.getActualTypeArguments();
            Class[] gTypes = new Class[gImpls.length];
            for (int i = 0; i < gImpls.length; ++i) {
                Type gt = gImpls[i];
                if (gt instanceof Class) {
                    gTypes[i] = (Class)gt;
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    gTypes[i] = (Class)upperBound;
                }
            }
            m.put((Class)rt, gTypes);
            BeanMeta.findTypeVarImpls(pt.getRawType(), m);
        }
    }

    public Object onReadProperty(Object bean, String name, Object value) {
        return this.beanFilter == null ? value : this.beanFilter.readProperty(bean, name, value);
    }

    public Object onWriteProperty(Object bean, String name, Object value) {
        return this.beanFilter == null ? value : this.beanFilter.writeProperty(bean, name, value);
    }

    static final String bpName(List<Beanp> p, List<Name> n) {
        if (p.isEmpty() && n.isEmpty()) {
            return null;
        }
        if (!n.isEmpty()) {
            return CollectionUtils.last(n).value();
        }
        Value<String> name = Value.of(p.isEmpty() ? null : "");
        p.forEach(x -> {
            if (!x.value().isEmpty()) {
                name.set(x.value());
            }
            if (!x.name().isEmpty()) {
                name.set(x.name());
            }
        });
        return name.orElse(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.c.getName());
        sb.append(" {\n");
        for (BeanPropertyMeta pm : this.propertyArray) {
            sb.append('\t').append(pm.toString()).append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return this.classMeta.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof BeanMeta && ObjectUtils.eq(this, (BeanMeta)o, (x, y) -> ObjectUtils.eq(x.classMeta, y.classMeta));
    }

    private static final class Builder<T> {
        ClassMeta<T> classMeta;
        BeanContext ctx;
        BeanFilter beanFilter;
        String[] pNames;
        Map<String, BeanPropertyMeta> properties;
        Map<String, BeanPropertyMeta> hiddenProperties = CollectionUtils.map();
        Map<Method, String> getterProps = CollectionUtils.map();
        Map<Method, String> setterProps = CollectionUtils.map();
        BeanPropertyMeta dynaProperty;
        Map<Class<?>, Class<?>[]> typeVarImpls;
        ConstructorInfo constructor;
        ConstructorInfo implClassConstructor;
        String[] constructorArgs = new String[0];
        PropertyNamer propertyNamer;
        BeanRegistry beanRegistry;
        String dictionaryName;
        String typePropertyName;
        boolean sortProperties;
        boolean fluentSetters;

        Builder(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames, ConstructorInfo implClassConstructor) {
            this.classMeta = classMeta;
            this.ctx = ctx;
            this.beanFilter = beanFilter;
            this.pNames = pNames;
            this.implClassConstructor = implClassConstructor;
        }

        String init(BeanMeta<T> beanMeta) {
            Class c = this.classMeta.getInnerClass();
            ClassInfo ci = this.classMeta.getInfo();
            try {
                LinkedHashMap<String, BeanPropertyMeta> properties2;
                Set<String> bfbpi;
                Class<Object> stopClass;
                Visibility conVis = this.ctx.getBeanConstructorVisibility();
                Visibility cVis = this.ctx.getBeanClassVisibility();
                Visibility mVis = this.ctx.getBeanMethodVisibility();
                Visibility fVis = this.ctx.getBeanFieldVisibility();
                ArrayList<Class> bdClasses = CollectionUtils.list(new Class[0]);
                if (this.beanFilter != null && this.beanFilter.getBeanDictionary() != null) {
                    CollectionUtils.addAll(bdClasses, this.beanFilter.getBeanDictionary());
                }
                Value typeName = Value.empty();
                this.classMeta.forEachAnnotation(Bean.class, x -> StringUtils.isNotEmpty(x.typeName()), x -> typeName.set(x.typeName()));
                if (typeName.isPresent()) {
                    bdClasses.add(this.classMeta.innerClass);
                }
                this.beanRegistry = new BeanRegistry(this.ctx, null, bdClasses.toArray(new Class[bdClasses.size()]));
                Value<String> typePropertyName = Value.empty();
                this.classMeta.forEachAnnotation(Bean.class, x -> StringUtils.isNotEmpty(x.typePropertyName()), x -> typePropertyName.set(x.typePropertyName()));
                this.typePropertyName = typePropertyName.orElseGet(() -> this.ctx.getBeanTypePropertyName());
                this.fluentSetters = this.ctx.isFindFluentSetters() || this.beanFilter != null && this.beanFilter.isFluentSetters();
                Class c2 = this.beanFilter != null && this.beanFilter.getInterfaceClass() != null ? this.beanFilter.getInterfaceClass() : c;
                Class clazz = stopClass = this.beanFilter != null ? this.beanFilter.getStopClass() : Object.class;
                if (stopClass == null) {
                    stopClass = Object.class;
                }
                LinkedHashMap<String, BeanPropertyMeta.Builder> normalProps = CollectionUtils.map();
                boolean hasBean = ci.hasAnnotation(this.ctx, Bean.class);
                boolean hasBeanIgnore = ci.hasAnnotation(this.ctx, BeanIgnore.class);
                if (this.ctx.isNotABean(c)) {
                    return "Class matches exclude-class list";
                }
                if (!(hasBean || cVis.isVisible(c.getModifiers()) || c.isAnonymousClass())) {
                    return "Class is not public";
                }
                if (hasBeanIgnore) {
                    return "Class is annotated with @BeanIgnore";
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSerializable() && !ci.isChildOf(Serializable.class)) {
                    return "Class is not serializable";
                }
                ci.forEachPublicConstructor(x -> x.hasAnnotation(this.ctx, Beanc.class), x -> {
                    if (this.constructor != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of '@Beanc' found.", new Object[0]);
                    }
                    this.constructor = x;
                    this.constructorArgs = new String[0];
                    this.ctx.forEachAnnotation(Beanc.class, x.inner(), y -> !y.properties().isEmpty(), z -> {
                        this.constructorArgs = StringUtils.split(z.properties());
                    });
                    if (!x.hasNumParams(this.constructorArgs.length)) {
                        if (this.constructorArgs.length != 0) {
                            throw new BeanRuntimeException(c, "Number of properties defined in '@Beanc' annotation does not match number of parameters in constructor.", new Object[0]);
                        }
                        this.constructorArgs = new String[x.getParamCount()];
                        IntValue i = IntValue.create();
                        x.forEachParam(null, pi -> {
                            String pn = pi.getName();
                            if (pn == null) {
                                throw new BeanRuntimeException(c, "Could not find name for parameter #{0} of constructor ''{1}''", i, x.getFullName());
                            }
                            this.constructorArgs[i.getAndIncrement()] = pn;
                        });
                    }
                    this.constructor.setAccessible();
                });
                if (this.constructor == null) {
                    ci.forEachDeclaredConstructor(x -> x.hasAnnotation(this.ctx, Beanc.class), x -> {
                        if (this.constructor != null) {
                            throw new BeanRuntimeException(c, "Multiple instances of '@Beanc' found.", new Object[0]);
                        }
                        this.constructor = x;
                        this.constructorArgs = new String[0];
                        this.ctx.forEachAnnotation(Beanc.class, x.inner(), y -> !y.properties().isEmpty(), z -> {
                            this.constructorArgs = StringUtils.split(z.properties());
                        });
                        if (!x.hasNumParams(this.constructorArgs.length)) {
                            if (this.constructorArgs.length != 0) {
                                throw new BeanRuntimeException(c, "Number of properties defined in '@Beanc' annotation does not match number of parameters in constructor.", new Object[0]);
                            }
                            this.constructorArgs = new String[x.getParamCount()];
                            IntValue i = IntValue.create();
                            x.forEachParam(null, y -> {
                                String pn = y.getName();
                                if (pn == null) {
                                    throw new BeanRuntimeException(c, "Could not find name for parameter #{0} of constructor ''{1}''", i, x.getFullName());
                                }
                                this.constructorArgs[i.getAndIncrement()] = pn;
                            });
                        }
                        this.constructor.setAccessible();
                    });
                }
                if (this.constructor == null) {
                    this.constructor = this.implClassConstructor;
                }
                if (this.constructor == null) {
                    this.constructor = ci.getNoArgConstructor(hasBean ? Visibility.PRIVATE : conVis);
                }
                if (this.constructor == null && this.beanFilter == null && this.ctx.isBeansRequireDefaultConstructor()) {
                    return "Class does not have the required no-arg constructor";
                }
                if (this.constructor != null) {
                    this.constructor.setAccessible();
                }
                LinkedHashSet<String> fixedBeanProps = CollectionUtils.set(new String[0]);
                LinkedHashSet<String> bpi = CollectionUtils.set(new String[0]);
                LinkedHashSet<String> bpx = CollectionUtils.set(new String[0]);
                LinkedHashSet<String> bpro = CollectionUtils.set(new String[0]);
                LinkedHashSet<String> bpwo = CollectionUtils.set(new String[0]);
                LinkedHashSet<String> filterProps = CollectionUtils.set(new String[0]);
                if (this.beanFilter != null) {
                    bfbpi = this.beanFilter.getProperties();
                    filterProps.addAll(bfbpi);
                    if (bpi.isEmpty()) {
                        fixedBeanProps.addAll(bfbpi);
                    }
                    if (this.beanFilter.getPropertyNamer() != null) {
                        this.propertyNamer = this.beanFilter.getPropertyNamer();
                    }
                    bpro.addAll(this.beanFilter.getReadOnlyProperties());
                    bpwo.addAll(this.beanFilter.getWriteOnlyProperties());
                }
                fixedBeanProps.addAll(bpi);
                if (this.propertyNamer == null) {
                    this.propertyNamer = this.ctx.getPropertyNamer();
                }
                fixedBeanProps.forEach(x -> normalProps.put((String)x, BeanPropertyMeta.builder(beanMeta, x)));
                if (this.ctx.isUseJavaBeanIntrospector()) {
                    BeanInfo bi = null;
                    bi = !c2.isInterface() ? Introspector.getBeanInfo(c2, stopClass) : Introspector.getBeanInfo(c2, null);
                    if (bi != null) {
                        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
                        int n = propertyDescriptorArray.length;
                        for (int i = 0; i < n; ++i) {
                            PropertyDescriptor pd = propertyDescriptorArray[i];
                            String name = pd.getName();
                            if (!normalProps.containsKey(name)) {
                                normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                            }
                            ((BeanPropertyMeta.Builder)normalProps.get(name)).setGetter(pd.getReadMethod()).setSetter(pd.getWriteMethod());
                        }
                    }
                } else {
                    BeanMeta.findBeanFields(this.ctx, c2, stopClass, fVis).forEach(x -> {
                        String name = this.findPropertyName((Field)x);
                        if (name != null) {
                            if (!normalProps.containsKey(name)) {
                                normalProps.put(name, BeanPropertyMeta.builder(beanMeta, name));
                            }
                            ((BeanPropertyMeta.Builder)normalProps.get(name)).setField((Field)x);
                        }
                    });
                    List<BeanMethod> bms = BeanMeta.findBeanMethods(this.ctx, c2, stopClass, mVis, this.propertyNamer, this.fluentSetters);
                    bms.forEach(x -> {
                        String pn = x.propertyName;
                        Method m = x.method;
                        if (!normalProps.containsKey(pn)) {
                            normalProps.put(pn, new BeanPropertyMeta.Builder(beanMeta, pn));
                        }
                        BeanPropertyMeta.Builder bpm = (BeanPropertyMeta.Builder)normalProps.get(pn);
                        if (x.methodType == MethodType.GETTER) {
                            if (bpm.getter != null) {
                                if (!this.ctx.hasAnnotation(Beanp.class, m) && this.ctx.hasAnnotation(Beanp.class, bpm.getter)) {
                                    m = bpm.getter;
                                } else if (m.getName().startsWith("is") && bpm.getter.getName().startsWith("get")) {
                                    m = bpm.getter;
                                }
                            }
                            bpm.setGetter(m);
                        }
                    });
                    bms.forEach(x -> {
                        BeanPropertyMeta.Builder bpm;
                        if (x.methodType == MethodType.SETTER && x.matchesPropertyType(bpm = (BeanPropertyMeta.Builder)normalProps.get(x.propertyName))) {
                            bpm.setSetter(x.method);
                        }
                    });
                    bms.forEach(x -> {
                        if (x.methodType == MethodType.EXTRAKEYS) {
                            BeanPropertyMeta.Builder bpm = (BeanPropertyMeta.Builder)normalProps.get(x.propertyName);
                            bpm.setExtraKeys(x.method);
                        }
                    });
                }
                this.typeVarImpls = CollectionUtils.map();
                BeanMeta.findTypeVarImpls(c, this.typeVarImpls);
                if (this.typeVarImpls.isEmpty()) {
                    this.typeVarImpls = null;
                }
                String[] i = normalProps.values().iterator();
                while (i.hasNext()) {
                    BeanPropertyMeta.Builder p = (BeanPropertyMeta.Builder)i.next();
                    try {
                        if (p.field == null) {
                            p.setInnerField(BeanMeta.findInnerBeanField(this.ctx, c, stopClass, p.name));
                        }
                        if (p.validate(this.ctx, this.beanRegistry, this.typeVarImpls, bpro, bpwo)) {
                            if (p.getter != null) {
                                this.getterProps.put(p.getter, p.name);
                            }
                            if (p.setter == null) continue;
                            this.setterProps.put(p.setter, p.name);
                            continue;
                        }
                        i.remove();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanRuntimeException(c, e.getLocalizedMessage(), new Object[0]);
                    }
                }
                fixedBeanProps.forEach(x -> {
                    if (!normalProps.containsKey(x)) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Bean(properties=X) annotation of class ''{1}'' but was not found on the class definition.", x, ci.getSimpleName());
                    }
                });
                for (String fp : this.constructorArgs) {
                    BeanPropertyMeta.Builder m = (BeanPropertyMeta.Builder)normalProps.get(fp);
                    if (m == null) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Beanc(properties=X) annotation but was not found on the class definition.", fp);
                    }
                    m.setAsConstructorArg();
                }
                if (this.beanFilter == null && this.ctx.isBeansRequireSomeProperties() && normalProps.size() == 0) {
                    return "No properties detected on bean class";
                }
                this.sortProperties = (this.ctx.isSortProperties() || this.beanFilter != null && this.beanFilter.isSortProperties()) && fixedBeanProps.isEmpty();
                Map<Object, Object> map = this.properties = this.sortProperties ? CollectionUtils.sortedMap() : CollectionUtils.map();
                if (this.beanFilter != null && this.beanFilter.getTypeName() != null) {
                    this.dictionaryName = this.beanFilter.getTypeName();
                }
                if (this.dictionaryName == null) {
                    this.dictionaryName = this.findDictionaryName(this.classMeta);
                }
                normalProps.forEach((k, v) -> {
                    BeanPropertyMeta pMeta = v.build();
                    if (pMeta.isDyna()) {
                        this.dynaProperty = pMeta;
                    }
                    this.properties.put((String)k, pMeta);
                });
                if (this.beanFilter != null) {
                    bfbpi = this.beanFilter.getProperties();
                    Set<String> bfbpx = this.beanFilter.getExcludeProperties();
                    if (bpi.isEmpty() && !bfbpi.isEmpty()) {
                        LinkedHashMap<String, BeanPropertyMeta> properties22 = CollectionUtils.map();
                        bfbpi.forEach(x -> {
                            if (this.properties.containsKey(x)) {
                                properties22.put((String)x, this.properties.remove(x));
                            }
                        });
                        this.hiddenProperties.putAll(this.properties);
                        this.properties = properties22;
                    }
                    if (bpx.isEmpty() && !bfbpx.isEmpty()) {
                        bfbpx.forEach(x -> this.hiddenProperties.put((String)x, this.properties.remove(x)));
                    }
                }
                if (!bpi.isEmpty()) {
                    properties2 = CollectionUtils.map();
                    bpi.forEach(x -> {
                        if (this.properties.containsKey(x)) {
                            properties2.put((String)x, this.properties.remove(x));
                        }
                    });
                    this.hiddenProperties.putAll(this.properties);
                    this.properties = properties2;
                }
                bpx.forEach(x -> this.hiddenProperties.put((String)x, this.properties.remove(x)));
                if (this.pNames != null) {
                    properties2 = CollectionUtils.map();
                    for (String k2 : this.pNames) {
                        if (this.properties.containsKey(k2)) {
                            properties2.put(k2, this.properties.get(k2));
                            continue;
                        }
                        this.hiddenProperties.put(k2, this.properties.get(k2));
                    }
                    this.properties = properties2;
                }
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return "Exception:  " + ThrowableUtils.getStackTrace(e);
            }
            return null;
        }

        private String findDictionaryName(ClassMeta<?> cm) {
            String s;
            String s2;
            BeanRegistry br = cm.getBeanRegistry();
            if (br != null && (s2 = br.getTypeName(this.classMeta)) != null) {
                return s2;
            }
            Class pcm = cm.innerClass.getSuperclass();
            if (pcm != null && (s = this.findDictionaryName(this.ctx.getClassMeta(pcm))) != null) {
                return s;
            }
            for (Class<?> icm : cm.innerClass.getInterfaces()) {
                String s3 = this.findDictionaryName(this.ctx.getClassMeta(icm));
                if (s3 == null) continue;
                return s3;
            }
            return null;
        }

        private String findPropertyName(Field f) {
            ArrayList<Beanp> lp = CollectionUtils.list(new Beanp[0]);
            ArrayList<Name> ln = CollectionUtils.list(new Name[0]);
            this.ctx.forEachAnnotation(Beanp.class, f, x -> true, x -> lp.add((Beanp)x));
            this.ctx.forEachAnnotation(Name.class, f, x -> true, x -> ln.add((Name)x));
            String name = BeanMeta.bpName(lp, ln);
            if (StringUtils.isNotEmpty(name)) {
                return name;
            }
            return this.propertyNamer.getPropertyName(f.getName());
        }
    }

    static enum MethodType {
        UNKNOWN,
        GETTER,
        SETTER,
        EXTRAKEYS;

    }

    private static final class BeanMethod {
        String propertyName;
        MethodType methodType;
        Method method;
        ClassInfo type;

        BeanMethod(String propertyName, MethodType type, Method method) {
            this.propertyName = propertyName;
            this.methodType = type;
            this.method = method;
            this.type = type == MethodType.SETTER ? ClassInfo.of(method.getParameterTypes()[0]) : ClassInfo.of(method.getReturnType());
        }

        boolean matchesPropertyType(BeanPropertyMeta.Builder b) {
            if (b == null) {
                return false;
            }
            if ("*".equals(b.name)) {
                return true;
            }
            Class<?> pt = null;
            if (b.getter != null) {
                pt = b.getter.getReturnType();
            } else if (b.field != null) {
                pt = b.field.getType();
            }
            if (pt == null) {
                return true;
            }
            if (!this.type.isParentOf(pt)) {
                return false;
            }
            if (b.setter == null) {
                return true;
            }
            return this.type.isStrictChildOf(b.setter.getParameterTypes()[0]);
        }

        public String toString() {
            return this.method.toString();
        }
    }
}

