/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.juneau.commons.io.LocalFile;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

public class LocalDir {
    private final Class<?> clazz;
    private final String clazzPath;
    private final Path path;
    private final int hashCode;

    private static boolean isClasspathFile(URL url) {
        return Utils.safeSupplier(() -> {
            if (url == null) {
                return false;
            }
            URI uri = url.toURI();
            if (uri.toString().startsWith("file:") && Files.isDirectory(Paths.get(uri), new LinkOption[0])) {
                return false;
            }
            return true;
        });
    }

    public LocalDir(Class<?> clazz, String clazzPath) {
        this.clazz = AssertionUtils.assertArgNotNull("clazz", clazz);
        this.clazzPath = "/".equals(clazzPath) ? "/" : Utils.nullIfEmpty(StringUtils.trimTrailingSlashes(clazzPath));
        this.path = null;
        this.hashCode = Utils.h(clazz, clazzPath);
    }

    public LocalDir(Path path) {
        this.clazz = null;
        this.clazzPath = null;
        this.path = AssertionUtils.assertArgNotNull("path", path);
        this.hashCode = path.hashCode();
    }

    public boolean equals(Object o) {
        LocalDir o2;
        return o instanceof LocalDir && Utils.eq(this, o2 = (LocalDir)o, (x, y) -> Utils.eq(x.clazz, y.clazz) && Utils.eq(x.clazzPath, y.clazzPath) && Utils.eq(x.path, y.path));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public LocalFile resolve(String path) {
        AssertionUtils.assertArgNotNull("path", path);
        if (Utils.nn(this.clazz)) {
            Object p = this.clazzPath == null ? path : ("/".equals(this.clazzPath) ? (path.startsWith("/") ? path : "/" + path) : (this.clazzPath.startsWith("/") ? this.clazzPath + "/" + path : this.clazzPath + "/" + path));
            if (LocalDir.isClasspathFile(this.clazz.getResource((String)p))) {
                return new LocalFile(this.clazz, (String)p);
            }
        } else {
            Path p = this.path.resolve(path);
            if (Files.isReadable(p) && !Files.isDirectory(p, new LinkOption[0])) {
                return new LocalFile(p);
            }
        }
        return null;
    }

    public String toString() {
        if (this.clazz == null) {
            return this.path.toString();
        }
        return Utils.cn(this.clazz) + ":" + this.clazzPath;
    }
}

