/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.ssh.KarafJaasAuthenticator;
import org.apache.karaf.shell.support.ShellUtil;
import org.apache.karaf.util.StreamUtils;
import org.apache.karaf.util.jaas.JaasHelper;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellCommand
implements Command,
Runnable,
SessionAware {
    public static final String SHELL_INIT_SCRIPT = "karaf.shell.init.script";
    public static final String EXEC_INIT_SCRIPT = "karaf.exec.init.script";
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellCommand.class);
    private static final Class[] SECURITY_BUGFIX = new Class[]{JaasHelper.class, JaasHelper.OsgiSubjectDomainCombiner.class, JaasHelper.DelegatingProtectionDomain.class};
    private String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;
    private SessionFactory sessionFactory;
    private Environment env;

    public ShellCommand(SessionFactory sessionFactory, String command) {
        this.sessionFactory = sessionFactory;
        this.command = command;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    public void start(Environment env) throws IOException {
        this.env = env;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int exitStatus = 0;
        try {
            final Session session = this.sessionFactory.create(this.in, new PrintStream(this.out), new PrintStream(this.err));
            for (Map.Entry e : this.env.getEnv().entrySet()) {
                session.put((String)e.getKey(), e.getValue());
            }
            try {
                Object result;
                Subject subject;
                Subject subject2 = subject = this.session != null ? (Subject)this.session.getAttribute(KarafJaasAuthenticator.SUBJECT_ATTRIBUTE_KEY) : null;
                if (subject != null) {
                    try {
                        result = JaasHelper.doAs(subject, new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                String scriptFileName = System.getProperty(ShellCommand.EXEC_INIT_SCRIPT);
                                if (scriptFileName == null) {
                                    scriptFileName = System.getProperty(ShellCommand.SHELL_INIT_SCRIPT);
                                }
                                ShellCommand.this.executeScript(scriptFileName, session);
                                return session.execute((CharSequence)ShellCommand.this.command);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw e.getException();
                    }
                } else {
                    String scriptFileName = System.getProperty(EXEC_INIT_SCRIPT);
                    if (scriptFileName == null) {
                        scriptFileName = System.getProperty(SHELL_INIT_SCRIPT);
                    }
                    this.executeScript(scriptFileName, session);
                    result = session.execute((CharSequence)this.command);
                }
                if (result == null) {
                    // empty if block
                }
            }
            catch (Throwable t) {
                exitStatus = 1;
                ShellUtil.logException((Session)session, (Throwable)t);
            }
        }
        catch (Exception e) {
            try {
                exitStatus = 1;
                LOGGER.error("Unable to start shell", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.close(this.in, this.out, this.err);
                this.callback.onExit(exitStatus);
                throw throwable;
            }
            StreamUtils.close(this.in, this.out, this.err);
            this.callback.onExit(exitStatus);
            return;
        }
        StreamUtils.close(this.in, this.out, this.err);
        this.callback.onExit(exitStatus);
        return;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String scriptFileName, Session session) {
        if (scriptFileName != null) {
            Reader r = null;
            try {
                int n;
                File scriptFile = new File(scriptFileName);
                r = new InputStreamReader(new FileInputStream(scriptFile));
                CharArrayWriter w = new CharArrayWriter();
                char[] buf = new char[8192];
                while ((n = r.read(buf)) > 0) {
                    w.write(buf, 0, n);
                }
                session.execute((CharSequence)new String(w.toCharArray()));
            }
            catch (Exception e) {
                LOGGER.debug("Error in initialization script", (Throwable)e);
            }
            finally {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

