/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class FeatureFinder
implements ManagedService {
    final Map<String, String> nameToArtifactMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNames() {
        Map<String, String> map = this.nameToArtifactMap;
        synchronized (map) {
            Set<String> strings = this.nameToArtifactMap.keySet();
            return strings.toArray(new String[strings.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getUriFor(String name, String version) {
        String url;
        Map<String, String> map = this.nameToArtifactMap;
        synchronized (map) {
            url = this.nameToArtifactMap.get(name);
        }
        if (url == null) {
            return null;
        }
        if (version != null) {
            url = FeatureFinder.replaceVersion(url, version);
        }
        return URI.create(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary properties) throws ConfigurationException {
        Map<String, String> map = this.nameToArtifactMap;
        synchronized (map) {
            if (properties != null) {
                this.nameToArtifactMap.clear();
                Enumeration keys = properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if ("felix.fileinstall.filename".equals(key) || "service.pid".equals(key)) continue;
                    this.nameToArtifactMap.put(key, (String)properties.get(key));
                }
            }
        }
    }

    private static String replaceVersion(String url, String version) {
        if (url.startsWith("mvn:")) {
            int index = url.indexOf(47);
            index = url.indexOf(47, index + 1);
            String first = url.substring(0, index);
            index = url.indexOf(47, index + 1);
            String second = url.substring(index + 1);
            return first + "/" + version + "/" + second;
        }
        return url;
    }
}

