/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;
import org.apache.karaf.features.command.completers.InstalledRepoUriCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="feature", name="repo-refresh", description="Refresh a features repository")
@Service
public class RepoRefreshCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="Feature name or uri", description="Shortcut name of the feature repository or the full URI", required=false, multiValued=false)
    @Completion(value=InstalledRepoUriCompleter.class)
    private String nameOrUrl;
    @Argument(index=1, name="Feature version", description="The version of the feature if using the feature name. Should be empty if using the uri", required=false, multiValued=false)
    private String version;

    @Override
    protected void doExecute(FeaturesService featuresService) throws Exception {
        ArrayList<Object> uris = new ArrayList<Object>();
        if (this.nameOrUrl != null) {
            String effectiveVersion = this.version == null ? "LATEST" : this.version;
            Object uri = featuresService.getRepositoryUriFor(this.nameOrUrl, effectiveVersion);
            if (uri == null) {
                Pattern pattern = Pattern.compile(this.nameOrUrl);
                for (Repository repository : featuresService.listRepositories()) {
                    URI u = repository.getURI();
                    Matcher matcher = pattern.matcher(u.toString());
                    if (!matcher.matches()) continue;
                    uris.add(u);
                }
            } else {
                uris.add(uri);
            }
        } else {
            Repository[] repos = featuresService.listRepositories();
            for (Repository repo : repos) {
                uris.add(repo.getURI());
            }
        }
        for (Object uri : uris) {
            try {
                System.out.println("Refreshing feature url " + uri);
                featuresService.refreshRepository((URI)uri);
            }
            catch (Exception e) {
                System.err.println("Error refreshing " + ((URI)uri).toString() + ": " + e.getMessage());
            }
        }
    }
}

