/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console.parsing;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.jline.ParsedLineImpl;
import org.apache.felix.gogo.runtime.Parser;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Session;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;

public class KarafParser
implements Parser {
    private final Session session;

    public KarafParser(Session session) {
        this.session = session;
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext parseContext) throws org.apache.felix.gogo.runtime.SyntaxError {
        try {
            return this.doParse(line, cursor);
        }
        catch (org.apache.felix.gogo.runtime.EOFError e) {
            throw new EOFError(e.line(), e.column(), e.getMessage(), e.missing());
        }
        catch (org.apache.felix.gogo.runtime.SyntaxError e) {
            throw new SyntaxError(e.line(), e.column(), e.getMessage());
        }
    }

    private ParsedLine doParse(CharSequence line, int cursor) throws org.apache.felix.gogo.runtime.SyntaxError {
        org.apache.felix.gogo.runtime.Parser parser = new org.apache.felix.gogo.runtime.Parser(line);
        Parser.Program program = parser.program();
        List<Parser.Statement> statements = parser.statements();
        Parser.Statement statement = null;
        for (int i = statements.size() - 1; i >= 0; --i) {
            Parser.Statement s = statements.get(i);
            if (s.start() > cursor) continue;
            boolean isOk = true;
            if (s.start() + s.length() < cursor) {
                for (int j = s.start() + s.length(); isOk && j < cursor; ++j) {
                    isOk = Character.isWhitespace(line.charAt(j));
                }
            }
            statement = s;
            break;
        }
        if (statement != null && statement.tokens() != null && !statement.tokens().isEmpty()) {
            org.apache.karaf.shell.api.console.Parser cmdParser;
            String cmdName = this.session.resolveCommand(statement.tokens().get(0).toString());
            String[] parts = cmdName.split(":");
            Command cmd = parts.length == 2 ? this.session.getRegistry().getCommand(parts[0], parts[1]) : null;
            org.apache.karaf.shell.api.console.Parser parser2 = cmdParser = cmd != null ? cmd.getParser() : null;
            if (cmdParser != null) {
                final CommandLine cmdLine = cmdParser.parse(this.session, statement.toString(), cursor - statement.start());
                return new ParsedLine(){

                    public String word() {
                        return cmdLine.getCursorArgument();
                    }

                    public int wordCursor() {
                        return cmdLine.getArgumentPosition();
                    }

                    public int wordIndex() {
                        return cmdLine.getCursorArgumentIndex();
                    }

                    public List<String> words() {
                        return Arrays.asList(cmdLine.getArguments());
                    }

                    public String line() {
                        return cmdLine.getBuffer();
                    }

                    public int cursor() {
                        return cmdLine.getBufferPosition();
                    }
                };
            }
            return new ParsedLineImpl(program, statement, cursor, statement.tokens());
        }
        return new ParsedLineImpl(program, program, cursor, Collections.singletonList(program));
    }
}

