/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.bundle.command.BundleCommand;
import org.apache.karaf.bundle.command.bundletree.Node;
import org.apache.karaf.bundle.command.bundletree.Tree;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="bundle", name="tree-show", description="Shows the tree of bundles based on the wiring information.")
@Service
public class ShowBundleTree
extends BundleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowBundleTree.class);
    @Option(name="-v", aliases={"--version"}, description="Show bundle versions")
    private boolean versions;
    private Tree<Bundle> tree;

    @Override
    protected Object doExecute(Bundle bundle) throws Exception {
        long start = System.currentTimeMillis();
        this.printHeader(bundle);
        this.tree = new Tree<Bundle>(bundle);
        this.createTree(bundle);
        this.printTree(this.tree);
        this.printDuplicatePackages(this.tree);
        LOGGER.debug(String.format("Dependency tree calculated in %d ms", System.currentTimeMillis() - start));
        return null;
    }

    private String getState(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "UNKNOWN";
    }

    private void printHeader(Bundle bundle) {
        System.out.printf("Bundle %s [%s] is currently %s%n", bundle.getSymbolicName(), bundle.getBundleId(), this.getState(bundle));
    }

    private void printTree(Tree<Bundle> tree) {
        System.out.printf("%n", new Object[0]);
        tree.write(System.out, new Tree.Converter<Bundle>(){

            @Override
            public String toString(Node<Bundle> node) {
                if (ShowBundleTree.this.versions) {
                    return String.format("%s / [%s] [%s]", node.getValue().getSymbolicName(), node.getValue().getVersion().toString(), node.getValue().getBundleId());
                }
                return String.format("%s [%s]", node.getValue().getSymbolicName(), node.getValue().getBundleId());
            }
        });
    }

    private void printDuplicatePackages(Tree<Bundle> tree) {
        Set bundles = tree.flatten();
        HashMap<String, Set> exports = new HashMap<String, Set>();
        for (Bundle bundle : bundles) {
            for (BundleRevision revision : ((BundleRevisions)bundle.adapt(BundleRevisions.class)).getRevisions()) {
                List wires;
                BundleWiring wiring = revision.getWiring();
                if (wiring == null || (wires = wiring.getProvidedWires("osgi.wiring.package")) == null) continue;
                for (BundleWire wire : wires) {
                    String name = wire.getCapability().getAttributes().get("osgi.wiring.package").toString();
                    exports.computeIfAbsent(name, k -> new HashSet()).add(bundle);
                }
            }
        }
        for (String pkg : exports.keySet()) {
            if (((Set)exports.get(pkg)).size() <= 1) continue;
            System.out.printf("%n", new Object[0]);
            System.out.printf("WARNING: multiple bundles are exporting package %s%n", pkg);
            for (Bundle bundle : (Set)exports.get(pkg)) {
                System.out.printf("- %s%n", bundle);
            }
        }
    }

    protected void createTree(Bundle bundle) {
        if (bundle.getState() >= 4) {
            this.createNode(this.tree);
        } else {
            this.createNodesForImports(this.tree, bundle);
            System.out.print("\nWarning: the below tree is a rough approximation of a possible resolution");
        }
    }

    private void createNodesForImports(Node<Bundle> node, Bundle bundle) {
        Clause[] imports = Parser.parseHeader((String)bundle.getHeaders().get("Import-Package"));
        Clause[] exports = Parser.parseHeader((String)bundle.getHeaders().get("Export-Package"));
        for (Clause i : imports) {
            boolean exported = false;
            for (Clause e : exports) {
                if (!e.getName().equals(i.getName())) continue;
                exported = true;
                break;
            }
            if (exported) continue;
            this.createNodeForImport(node, bundle, i);
        }
    }

    private void createNodeForImport(Node<Bundle> node, Bundle bundle, Clause i) {
        VersionRange range = VersionRange.parseVersionRange(i.getAttribute("version"));
        boolean foundMatch = false;
        for (Bundle b : this.bundleContext.getBundles()) {
            List caps;
            BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
            if (wiring == null || (caps = wiring.getCapabilities("osgi.wiring.package")) == null) continue;
            for (BundleCapability cap : caps) {
                String n = this.getAttribute(cap, "osgi.wiring.package");
                String v = this.getAttribute(cap, "version");
                if (!i.getName().equals(n) || !range.contains(VersionTable.getVersion(v))) continue;
                boolean existing = this.tree.flatten().contains(b);
                System.out.printf("- import %s: resolved using %s%n", i, b);
                foundMatch = true;
                if (node.hasChild(b)) continue;
                Node<Bundle> child = node.addChild(b);
                if (existing) continue;
                this.createNode(child);
            }
        }
        if (!foundMatch) {
            System.out.printf("- import %s: WARNING - unable to find matching export%n", i);
        }
    }

    private String getAttribute(BundleCapability capability, String name) {
        Object o = capability.getAttributes().get(name);
        return o != null ? o.toString() : null;
    }

    private void createNode(Node<Bundle> node) {
        Bundle bundle = node.getValue();
        HashSet<Bundle> exporters = new HashSet<Bundle>();
        exporters.addAll(this.bundleService.getWiredBundles(bundle).values());
        for (Bundle exporter : exporters) {
            if (node.hasAncestor(exporter)) {
                LOGGER.debug(String.format("Skipping %s (already exists in the current branch)", exporter));
                continue;
            }
            boolean existing = this.tree.flatten().contains(exporter);
            LOGGER.debug(String.format("Adding %s as a dependency for %s", exporter, bundle));
            Node<Bundle> child = node.addChild(exporter);
            if (existing) {
                LOGGER.debug(String.format("Skipping children of %s (already exists in another branch)", exporter));
                continue;
            }
            this.createNode(child);
        }
    }
}

