/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.scp;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.scp.ScpException;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.scp.ScpTransferEventListener;
import org.apache.sshd.common.scp.helpers.DefaultScpFileOpener;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.AbstractFileSystemCommand;
import org.apache.sshd.server.scp.InputStreamReader;

public class ScpShell
extends AbstractFileSystemCommand {
    public static final String NAME_ENCODING_CHARSET = "scp-shell-name-encoding-charset";
    public static final Charset DEFAULT_NAME_ENCODING_CHARSET = StandardCharsets.UTF_8;
    public static final String STATUS = "status";
    public static final String ENV_PWD = "PWD";
    public static final String ENV_HOME = "HOME";
    public static final String ENV_LANG = "LANG";
    protected final ChannelSession channel;
    protected final Map<String, Object> variables = new HashMap<String, Object>();
    protected final Charset nameEncodingCharset;
    protected final ScpFileOpener opener;
    protected final ScpTransferEventListener listener;
    protected final int sendBufferSize;
    protected final int receiveBufferSize;
    protected Path currentDir;
    protected Path homeDir;

    public ScpShell(ChannelSession channel, CloseableExecutorService executorService, int sendSize, int receiveSize, ScpFileOpener fileOpener, ScpTransferEventListener eventListener) {
        super(null, executorService);
        this.channel = channel;
        this.nameEncodingCharset = PropertyResolverUtils.getCharset((PropertyResolver)channel, (String)NAME_ENCODING_CHARSET, (Charset)DEFAULT_NAME_ENCODING_CHARSET);
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpShell> send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommmand> receive buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
        this.opener = fileOpener == null ? DefaultScpFileOpener.INSTANCE : fileOpener;
        this.listener = eventListener == null ? ScpTransferEventListener.EMPTY : eventListener;
    }

    public void setFileSystemFactory(FileSystemFactory factory, SessionContext session) throws IOException {
        this.homeDir = factory.getUserHomeDir(session);
        super.setFileSystemFactory(factory, session);
    }

    protected void println(String cmd, Object x, OutputStream out, Charset cs) {
        try {
            String s = x.toString();
            if (this.log.isDebugEnabled()) {
                this.log.debug("println({})[{}]: {}", new Object[]{this.channel, cmd, s.replace('\n', ' ').replace('\t', ' ')});
            }
            out.write(s.getBytes(cs));
            out.write(10);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected void signalError(String cmd, String errorMsg) {
        this.signalError(cmd, errorMsg, StandardCharsets.US_ASCII);
    }

    protected void signalError(String cmd, String errorMsg, Charset cs) {
        this.log.warn("{}[{}]: {}", new Object[]{this.channel, cmd, errorMsg});
        this.println(cmd, errorMsg, this.getErrorStream(), cs);
        this.variables.put(STATUS, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        command = null;
        this.variables.put("status", 0);
        debugEnabled = this.log.isDebugEnabled();
        try {
            if (this.homeDir == null) {
                this.currentDir = this.opener.resolveLocalPath((Session)this.channel.getSession(), this.fileSystem, ".");
                this.log.warn("run - no home dir - starting at {}", (Object)this.currentDir);
            } else {
                this.currentDir = this.homeDir;
                if (debugEnabled) {
                    this.log.debug("run - starting at home dir={}", (Object)this.homeDir);
                }
            }
            this.prepareEnvironment(this.getEnvironment());
            r = new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8);
            var4_6 = null;
            executedCommands = 0;
lbl18:
            // 2 sources

            while (true) {
                command = this.readLine(r);
                if (!GenericUtils.isEmpty((CharSequence)command)) ** GOTO lbl-1000
                if (debugEnabled) {
                    this.log.debug("run({}) Command loop terminated after {} commands", (Object)this.channel, (Object)executedCommands);
                }
                if (r == null) return;
                if (var4_6 != null) {
                }
                ** GOTO lbl47
                break;
            }
            {
                block34: {
                    block35: {
                        catch (Throwable executedCommands) {
                            var4_6 = executedCommands;
                            throw executedCommands;
                        }
                        catch (Throwable var7_13) {
                            if (r == null) throw var7_13;
                            if (var4_6 == null) {
                                r.close();
                                throw var7_13;
                            }
                            try {
                                r.close();
                                throw var7_13;
                            }
                            catch (Throwable var8_14) {
                                var4_6.addSuppressed(var8_14);
                                throw var7_13;
                            }
                        }
                        try {
                            r.close();
                            return;
                        }
                        catch (Throwable var6_11) {
                            var4_6.addSuppressed(var6_11);
                            return;
                        }
lbl47:
                        // 1 sources

                        r.close();
                        return;
lbl-1000:
                        // 1 sources

                        {
                            if (this.handleCommandLine(command)) break block34;
                            if (debugEnabled) {
                                this.log.debug("run({}) Command loop terminated by cmd={} after {} commands", new Object[]{this.channel, command, executedCommands});
                            }
                            if (r == null) return;
                            if (var4_6 == null) break block35;
                        }
                        try {
                            r.close();
                            return;
                        }
                        catch (Throwable var6_12) {
                            var4_6.addSuppressed(var6_12);
                            return;
                        }
                    }
                    r.close();
                    return;
                }
                ** try [egrp 7[TRYBLOCK] [11, 14 : 294->346)] { 
lbl-1000:
                // 1 sources

                {
                    ++executedCommands;
                    ** continue;
                }
            }
        }
lbl67:
        // 2 sources

        catch (InterruptedIOException e) {
            if (debugEnabled == false) return;
            this.log.debug("run({}) interrupted after command={}", (Object)this.channel, command);
            return;
        }
lbl71:
        // 2 sources

        catch (Exception e) {
            message = "Failed (" + e.getClass().getSimpleName() + ") to handle '" + command + "': " + e.getMessage();
            this.log.warn("run({}) {}", (Object)this.channel, (Object)message);
            try {
                stderr = this.getErrorStream();
                stderr.write(message.getBytes(StandardCharsets.US_ASCII));
                return;
            }
            catch (IOException ioe) {
                this.log.warn("run({}) Failed ({}) to write error message={}: {}", new Object[]{this.channel, ioe.getClass().getSimpleName(), message, ioe.getMessage()});
                return;
            }
            finally {
                this.onExit(-1, message);
            }
        }
        finally {
            this.onExit(0);
        }
    }

    protected String readLine(Reader reader) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) >= 0 && c != 10) {
            sb.append((char)c);
        }
        int len = sb.length();
        if (len > 0 && sb.charAt(len - 1) == '\r') {
            sb.setLength(len - 1);
        }
        return sb.toString();
    }

    protected boolean handleCommandLine(String command) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleCommandLine({}) {}", (Object)this.channel, (Object)command);
        }
        List<String[]> cmds = this.parse(command);
        OutputStream stdout = this.getOutputStream();
        OutputStream stderr = this.getErrorStream();
        for (String[] argv : cmds) {
            switch (argv[0]) {
                case "echo": {
                    this.echo(argv);
                    break;
                }
                case "pwd": {
                    this.pwd(argv);
                    break;
                }
                case "cd": {
                    this.cd(argv);
                    break;
                }
                case "ls": {
                    this.ls(argv);
                    break;
                }
                case "scp": {
                    this.scp(argv);
                    break;
                }
                case "groups": {
                    this.variables.put(STATUS, 0);
                    break;
                }
                case "printenv": {
                    this.printenv(argv);
                    break;
                }
                case "unset": {
                    this.unset(argv);
                    break;
                }
                case "unalias": {
                    this.variables.put(STATUS, 1);
                    break;
                }
                default: {
                    this.handleUnsupportedCommand(command, argv);
                }
            }
            stdout.flush();
            stderr.flush();
        }
        return true;
    }

    protected void prepareEnvironment(Environment environ) {
        Map env = environ.getEnv();
        Locale locale = Locale.getDefault();
        String languageTag = locale.toLanguageTag();
        env.put(ENV_LANG, languageTag.replace('-', '_') + "." + this.nameEncodingCharset.displayName());
        if (this.homeDir != null) {
            env.put(ENV_HOME, this.homeDir.toString());
        }
        this.updatePwdEnvVariable(this.currentDir);
    }

    protected void handleUnsupportedCommand(String command, String[] argv) throws Exception {
        this.log.warn("handleUnsupportedCommand({}) unsupported: {}", (Object)this.channel, (Object)command);
        this.variables.put(STATUS, 127);
        this.getErrorStream().write(("command not found: " + argv[0] + "\n").getBytes(StandardCharsets.US_ASCII));
    }

    protected List<String[]> parse(String command) {
        ArrayList<String[]> cmds = new ArrayList<String[]>();
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder arg = new StringBuilder();
        char quote = '\u0000';
        boolean escaped = false;
        for (int i = 0; i < command.length(); ++i) {
            char ch = command.charAt(i);
            if (escaped) {
                arg.append(ch);
                escaped = false;
                continue;
            }
            if (ch == quote) {
                quote = '\u0000';
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                quote = ch;
                continue;
            }
            if (ch == '\\') {
                escaped = true;
                continue;
            }
            if (quote == '\u0000' && Character.isWhitespace(ch)) {
                if (arg.length() <= 0) continue;
                args.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            if (quote == '\u0000' && ch == ';') {
                if (arg.length() > 0) {
                    args.add(arg.toString());
                    arg.setLength(0);
                }
                if (!args.isEmpty()) {
                    cmds.add(args.toArray(new String[0]));
                }
                args.clear();
                continue;
            }
            arg.append(ch);
        }
        if (arg.length() > 0) {
            args.add(arg.toString());
            arg.setLength(0);
        }
        if (!args.isEmpty()) {
            cmds.add(args.toArray(new String[0]));
        }
        return cmds;
    }

    protected void printenv(String[] argv) throws Exception {
        Environment environ = this.getEnvironment();
        Map envValues = environ.getEnv();
        OutputStream stdout = this.getOutputStream();
        if (argv.length == 1) {
            envValues.entrySet().stream().forEach(e -> this.println(argv[0], (String)e.getKey() + "=" + (String)e.getValue(), stdout, StandardCharsets.US_ASCII));
            this.variables.put(STATUS, 0);
            return;
        }
        if (argv.length != 2) {
            this.signalError(argv[0], "printenv: only one variable value at a time");
            return;
        }
        String varName = argv[1];
        String varValue = this.resolveEnvironmentVariable(varName, envValues);
        if (varValue == null) {
            this.signalError(argv[0], "printenv: variable not set " + varName);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("printenv({}) {}={}", new Object[]{this.channel, varName, varValue});
        }
        this.println(argv[0], varValue, stdout, StandardCharsets.US_ASCII);
        this.variables.put(STATUS, 0);
    }

    protected String resolveEnvironmentVariable(String varName, Map<String, String> envValues) {
        return envValues.get(varName);
    }

    protected void unset(String[] argv) throws Exception {
        if (argv.length != 2) {
            this.signalError(argv[0], "unset: exactly one argument is expected");
            return;
        }
        Environment environ = this.getEnvironment();
        Map envValues = environ.getEnv();
        String varName = argv[1];
        String varValue = (String)envValues.remove(varName);
        if (this.log.isDebugEnabled()) {
            this.log.debug("unset({}) {}={}", new Object[]{this.channel, varName, varValue});
        }
        this.variables.put(STATUS, varValue == null ? 1 : 0);
    }

    protected void scp(String[] argv) throws Exception {
        boolean optR = false;
        boolean optT = false;
        boolean optF = false;
        boolean optD = false;
        boolean optP = false;
        boolean isOption = true;
        String path = null;
        for (int i = 1; i < argv.length; ++i) {
            String argVal = argv[i];
            if (GenericUtils.isEmpty((CharSequence)argVal)) {
                this.signalError(argv[0], "scp: empty argument not allowed");
                return;
            }
            if (isOption && argVal.charAt(0) == '-') {
                if (argVal.length() != 2) {
                    this.signalError(argv[0], "scp: only one option at a time may be specified");
                    return;
                }
                char optVal = argVal.charAt(1);
                switch (optVal) {
                    case 'r': {
                        optR = true;
                        break;
                    }
                    case 't': {
                        optT = true;
                        break;
                    }
                    case 'f': {
                        optF = true;
                        break;
                    }
                    case 'd': {
                        optD = true;
                        break;
                    }
                    case 'p': {
                        optP = true;
                        break;
                    }
                    default: {
                        this.signalError(argv[0], "scp: unsupported option: " + argVal);
                        return;
                    }
                }
                continue;
            }
            if (path == null) {
                path = argVal;
                isOption = false;
                continue;
            }
            this.signalError(argv[0], "scp: one and only one path argument expected");
            return;
        }
        if (optT && optF || !optT && !optF) {
            this.signalError(argv[0], "scp: one and only one of -t and -f option expected");
            return;
        }
        this.doScp(path, optR, optT, optF, optD, optP);
    }

    protected void doScp(String path, boolean optR, boolean optT, boolean optF, boolean optD, boolean optP) throws Exception {
        try {
            ScpHelper helper = new ScpHelper((Session)this.channel.getSession(), this.getInputStream(), this.getOutputStream(), this.fileSystem, this.opener, this.listener);
            Path localPath = this.currentDir.resolve(path);
            if (optT) {
                helper.receive(localPath, optR, optD, optP, this.receiveBufferSize);
            } else {
                helper.send(Collections.singletonList(localPath.toString()), optR, optP, this.sendBufferSize);
            }
            this.variables.put(STATUS, 0);
        }
        catch (IOException e) {
            int exitValue;
            Integer statusCode = e instanceof ScpException ? ((ScpException)e).getExitStatus() : null;
            int n = exitValue = statusCode == null ? 2 : statusCode;
            if (exitValue == 0 || exitValue == 1) {
                exitValue = 2;
            }
            String exitMessage = GenericUtils.trimToEmpty((String)e.getMessage());
            ScpHelper.sendResponseMessage(this.getOutputStream(), exitValue, exitMessage);
            this.variables.put(STATUS, exitValue);
        }
    }

    protected void echo(String[] argv) throws Exception {
        StringBuilder buf = new StringBuilder();
        for (int k = 1; k < argv.length; ++k) {
            String arg = argv[k];
            if (buf.length() > 0) {
                buf.append(' ');
            }
            int vstart = -1;
            for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                if (vstart >= 0) {
                    if (c == '_' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
                    if (vstart == i) {
                        buf.append('$');
                    } else {
                        String n = arg.substring(vstart, i);
                        Object v = this.variables.get(n);
                        if (v != null) {
                            buf.append(v);
                        }
                    }
                    vstart = -1;
                    continue;
                }
                if (c == '$') {
                    vstart = i + 1;
                    continue;
                }
                buf.append(c);
            }
            if (vstart < 0) continue;
            String n = arg.substring(vstart);
            if (n.isEmpty()) {
                buf.append('$');
                continue;
            }
            Object v = this.variables.get(n);
            if (v == null) continue;
            buf.append(v);
        }
        this.println(argv[0], buf, this.getOutputStream(), this.nameEncodingCharset);
        this.variables.put(STATUS, 0);
    }

    protected void pwd(String[] argv) throws Exception {
        if (argv.length != 1) {
            this.signalError(argv[0], "pwd: too many arguments");
        } else {
            this.println(argv[0], this.currentDir, this.getOutputStream(), this.nameEncodingCharset);
            this.variables.put(STATUS, 0);
        }
    }

    protected void cd(String[] argv) throws Exception {
        if (argv.length == 1) {
            if (this.homeDir != null) {
                this.currentDir = this.homeDir;
                this.updatePwdEnvVariable(this.currentDir);
                this.variables.put(STATUS, 0);
            } else {
                this.signalError(argv[0], "No home directory to return to");
            }
            return;
        }
        if (argv.length != 2) {
            this.signalError(argv[0], "cd: too many or too few arguments");
            return;
        }
        String path = argv[1];
        if (GenericUtils.isEmpty((CharSequence)path)) {
            this.signalError(argv[0], "cd: empty target");
            return;
        }
        Path cwd = this.currentDir;
        if (!Files.exists(cwd = cwd.resolve(path).toAbsolutePath().normalize(), new LinkOption[0])) {
            this.signalError(argv[0], "no such file or directory: " + path, this.nameEncodingCharset);
        } else if (!Files.isDirectory(cwd, new LinkOption[0])) {
            this.signalError(argv[0], "not a directory: " + path, this.nameEncodingCharset);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("cd - {} => {}", (Object)this.currentDir, (Object)cwd);
            }
            this.currentDir = cwd;
            this.updatePwdEnvVariable(this.currentDir);
            this.variables.put(STATUS, 0);
        }
    }

    protected void updatePwdEnvVariable(Path pwd) {
        Environment environ = this.getEnvironment();
        Map envVars = environ.getEnv();
        envVars.put(ENV_PWD, pwd.toString());
    }

    protected void ls(String[] argv) throws Exception {
        boolean optListAll = false;
        boolean optDirAsPlain = false;
        boolean optLong = false;
        boolean optFullTime = false;
        String path = null;
        for (int k = 1; k < argv.length; ++k) {
            String argValue = argv[k];
            if (GenericUtils.isEmpty((CharSequence)argValue)) {
                this.signalError(argv[0], "ls: empty argument not allowed");
                return;
            }
            if (argValue.equals("--full-time")) {
                optFullTime = true;
                continue;
            }
            if (argValue.charAt(0) == '-') {
                int argLen = argValue.length();
                if (argLen == 1) {
                    this.signalError(argv[0], "ls: no option specified");
                    return;
                }
                block6: for (int i = 1; i < argLen; ++i) {
                    char optValue = argValue.charAt(i);
                    switch (optValue) {
                        case 'a': {
                            optListAll = true;
                            continue block6;
                        }
                        case 'd': {
                            optDirAsPlain = true;
                            continue block6;
                        }
                        case 'l': {
                            optLong = true;
                            continue block6;
                        }
                        default: {
                            this.signalError(argv[0], "unsupported option: -" + optValue);
                            return;
                        }
                    }
                }
                continue;
            }
            if (path == null) {
                path = argValue;
                continue;
            }
            this.signalError(argv[0], "unsupported option: " + argValue);
            return;
        }
        this.doLs(argv[0], path, optListAll, optLong, optFullTime);
    }

    protected void doLs(String cmd, String path, boolean optListAll, boolean optLong, boolean optFullTime) throws Exception {
        Predicate<Path> filter = p -> {
            String fileName = p.getFileName().toString();
            return optListAll || fileName.equals(".") || fileName.equals("..") || !fileName.startsWith(".");
        };
        Stream<Path> files = path != null ? Stream.of(this.currentDir.resolve(path)) : Stream.concat(Stream.of(".", "..").map(this.currentDir::resolve), Files.list(this.currentDir));
        OutputStream stdout = this.getOutputStream();
        OutputStream stderr = this.getErrorStream();
        this.variables.put(STATUS, 0);
        files.filter(filter).map(p -> new PathEntry((Path)p, this.currentDir)).sorted().forEach(p -> {
            try {
                String str = p.display(optLong, optFullTime);
                this.println(cmd, str, stdout, this.nameEncodingCharset);
            }
            catch (NoSuchFileException e) {
                this.println(cmd, cmd + ": " + p.path.toString() + ": no such file or directory", stderr, this.nameEncodingCharset);
                this.variables.put(STATUS, 1);
            }
        });
    }

    protected static class PathEntry
    implements Comparable<PathEntry> {
        public static final DateTimeFormatter FULL_TIME_VALUE_FORMATTER = DateTimeFormatter.ofPattern("MMM ppd HH:mm:ss yyyy");
        public static final DateTimeFormatter TIME_ONLY_VALUE_FORMATTER = DateTimeFormatter.ofPattern("MMM ppd HH:mm");
        public static final DateTimeFormatter YEAR_VALUE_FORMATTER = DateTimeFormatter.ofPattern("MMM ppd  yyyy");
        protected final Path abs;
        protected final Path path;
        protected final Map<String, Object> attributes;

        public PathEntry(Path abs, Path root) {
            this.abs = abs;
            this.path = abs.startsWith(root) ? root.relativize(abs) : abs;
            this.attributes = PathEntry.readAttributes(abs);
        }

        @Override
        public int compareTo(PathEntry o) {
            return this.path.toString().compareTo(o.path.toString());
        }

        public String toString() {
            return Objects.toString(this.abs);
        }

        public String display(boolean optLongDisplay, boolean optFullTime) throws NoSuchFileException {
            if (this.attributes.isEmpty()) {
                throw new NoSuchFileException(this.path.toString());
            }
            String abbrev = this.shortDisplay();
            if (!optLongDisplay) {
                return abbrev;
            }
            StringBuilder sb = new StringBuilder(abbrev.length() + 64);
            if (this.is("isDirectory")) {
                sb.append('d');
            } else if (this.is("isSymbolicLink")) {
                sb.append('l');
            } else if (this.is("isOther")) {
                sb.append('o');
            } else {
                sb.append('-');
            }
            EnumSet<PosixFilePermission> perms = (EnumSet<PosixFilePermission>)this.attributes.get("permissions");
            if (perms == null) {
                perms = EnumSet.noneOf(PosixFilePermission.class);
            }
            sb.append(PosixFilePermissions.toString(perms));
            Object nlinkValue = this.attributes.get("nlink");
            sb.append(' ').append(String.format("%3s", nlinkValue != null ? nlinkValue : "1"));
            this.appendOwnerInformation(sb, "owner", "owner");
            this.appendOwnerInformation(sb, "group", "group");
            Number length = (Number)this.attributes.get("size");
            if (length == null) {
                length = 0L;
            }
            sb.append(' ').append(String.format("%1$8s", length));
            String timeValue = PathEntry.toString((FileTime)this.attributes.get("lastModifiedTime"), optFullTime);
            sb.append(' ').append(timeValue);
            sb.append(' ').append(abbrev);
            return sb.toString();
        }

        protected boolean is(String attr) {
            Object d = this.attributes.get(attr);
            return d instanceof Boolean && (Boolean)d != false;
        }

        protected StringBuilder appendOwnerInformation(StringBuilder sb, String attr, String defaultValue) {
            String owner = Objects.toString(this.attributes.get(attr), null);
            if (GenericUtils.isEmpty((CharSequence)owner)) {
                owner = defaultValue;
            }
            if (owner.length() > 8) {
                owner = owner.substring(0, 8);
            }
            sb.append(' ').append(owner);
            for (int index = owner.length(); index < 8; ++index) {
                sb.append(' ');
            }
            return sb;
        }

        protected String shortDisplay() {
            String str;
            if (this.is("isSymbolicLink")) {
                try {
                    Path l = Files.readSymbolicLink(this.abs);
                    return this.path + " -> " + l;
                }
                catch (IOException l) {
                    // empty catch block
                }
            }
            if ((str = this.path.toString()).isEmpty()) {
                return this.abs.getFileName().toString();
            }
            return str;
        }

        protected static String toString(FileTime time, boolean optFullTime) {
            long millis;
            long l = millis = time != null ? time.toMillis() : -1L;
            if (millis < 0L) {
                return "------------";
            }
            ZonedDateTime dt = Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault());
            if (optFullTime) {
                return FULL_TIME_VALUE_FORMATTER.format(dt);
            }
            if (System.currentTimeMillis() - millis < 15811200000L) {
                return TIME_ONLY_VALUE_FORMATTER.format(dt);
            }
            return YEAR_VALUE_FORMATTER.format(dt);
        }

        protected static Map<String, Object> readAttributes(Path path) {
            TreeMap<String, Object> attrs = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            FileSystem fs = path.getFileSystem();
            Set<String> views = fs.supportedFileAttributeViews();
            for (String view : views) {
                try {
                    Map<String, Object> ta = Files.readAttributes(path, view + ":*", IoUtils.getLinkOptions((boolean)false));
                    ta.forEach(attrs::putIfAbsent);
                }
                catch (IOException iOException) {}
            }
            if (!attrs.isEmpty()) {
                attrs.computeIfAbsent("isExecutable", s -> Files.isExecutable(path));
                attrs.computeIfAbsent("permissions", s -> IoUtils.getPermissionsFromFile((File)path.toFile()));
            }
            return attrs;
        }
    }
}

