/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.util.ContentTypeUtils;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.ContentType;

abstract class HTTPMessage {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private String clientIPAddress;

    HTTPMessage() {
    }

    public ContentType getContentType() {
        String value = this.getHeaderValue("Content-Type");
        if (value == null) {
            return null;
        }
        try {
            return new ContentType(value);
        }
        catch (javax.mail.internet.ParseException e) {
            return null;
        }
    }

    public void setContentType(ContentType ct) {
        this.setHeader("Content-Type", ct != null ? ct.toString() : null);
    }

    public void setContentType(String ct) throws ParseException {
        try {
            this.setHeader("Content-Type", ct != null ? new ContentType(ct).toString() : null);
        }
        catch (javax.mail.internet.ParseException e) {
            throw new ParseException("Invalid Content-Type value: " + e.getMessage());
        }
    }

    public void ensureContentType() throws ParseException {
        if (this.getContentType() == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, this.getContentType());
    }

    public String getHeaderValue(String name) {
        return MultivaluedMapUtils.getFirstValue(this.headers, name);
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String ... values) {
        if (values != null && values.length > 0) {
            this.headers.put(name, Arrays.asList(values));
        } else {
            this.headers.remove(name);
        }
    }

    public Map<String, List<String>> getHeaderMap() {
        return this.headers;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }
}

