/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi.local;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.NamingManager;
import org.eclipse.jetty.jndi.NamingContext;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class localContextRoot
implements Context {
    private static final Logger LOG = Log.getLogger(localContextRoot.class);
    protected static final NamingContext __root = new NamingRoot();
    private final Hashtable<String, Object> _env;

    public static NamingContext getRoot() {
        return __root;
    }

    public localContextRoot(Hashtable env) {
        this._env = new Hashtable(env);
    }

    @Override
    public void close() throws NamingException {
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        __root.destroySubcontext(this.getSuffix(name));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(__root.getNameParser("").parse(this.getSuffix(name)));
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._env;
    }

    private Object dereference(Object ctx, String firstComponent) throws NamingException {
        if (ctx instanceof Reference) {
            try {
                return NamingManager.getObjectInstance(ctx, this.getNameParser("").parse(firstComponent), __root, this._env);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                throw new NamingException(e.getMessage());
            }
        }
        return ctx;
    }

    private Context getContext(Name cname) throws NamingException {
        String firstComponent = cname.get(0);
        if (firstComponent.equals("")) {
            return this;
        }
        Binding binding = __root.getBinding(firstComponent);
        if (binding == null) {
            NameNotFoundException nnfe = new NameNotFoundException(firstComponent + " is not bound");
            nnfe.setRemainingName(cname);
            throw nnfe;
        }
        Object ctx = this.dereference(binding.getObject(), firstComponent);
        if (!(ctx instanceof Context)) {
            throw new NotContextException(firstComponent + " not a context in " + this.getNameInNamespace());
        }
        return (Context)ctx;
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.size() == 0) {
            return;
        }
        if (__root.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = __root.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            __root.removeBinding(cname);
        } else {
            this.getContext(cname).unbind(cname.getSuffix(1));
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(__root.getNameParser("").parse(this.getSuffix(name)));
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(__root.getNameParser("").parse(this.getSuffix(name)));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        Name cname = __root.toCanonicalName(name);
        if (cname == null || cname.isEmpty()) {
            return __root.shallowCopy();
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = __root.getBinding(cname);
            if (binding == null) {
                throw new NameNotFoundException();
            }
            Object o = binding.getObject();
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname.getPrefix(1), __root, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("", (Throwable)e);
                    throw new NamingException(e.getMessage());
                }
            }
            return o;
        }
        return this.getContext(cname).lookup(cname.getSuffix(1));
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this._env.remove(propName);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        Name cname;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up name=\"" + name + "\"", new Object[0]);
        }
        if ((cname = __root.toCanonicalName(name)) == null || cname.isEmpty()) {
            return __root.shallowCopy();
        }
        if (cname.size() == 1) {
            Binding binding = __root.getBinding(cname);
            if (binding == null) {
                NameNotFoundException nnfe = new NameNotFoundException();
                nnfe.setRemainingName(cname);
                throw nnfe;
            }
            Object o = binding.getObject();
            if (o instanceof LinkRef) {
                String linkName = ((LinkRef)o).getLinkName();
                if (linkName.startsWith("./")) {
                    return this.lookup(linkName.substring(2));
                }
                InitialContext ictx = new InitialContext();
                return ictx.lookup(linkName);
            }
            if (o instanceof Reference) {
                try {
                    return NamingManager.getObjectInstance(o, cname, __root, this._env);
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NamingException(e.getMessage()){
                        {
                            super(arg0);
                            this.initCause(e);
                        }
                    };
                }
            }
            return o;
        }
        return this.getContext(cname).lookup(cname.getSuffix(1));
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(__root.getNameParser("").parse(this.getSuffix(name)));
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(__root.getNameParser("").parse(this.getSuffix(name)), obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (__root.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = __root.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, this, this._env);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            __root.addBinding(cname, objToBind);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
            }
            this.getContext(cname).bind(cname.getSuffix(1), obj);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (__root.isLocked()) {
            throw new NamingException("This context is immutable");
        }
        Name cname = __root.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Object objToBind = NamingManager.getStateToBind(obj, name, __root, this._env);
            if (objToBind instanceof Referenceable) {
                objToBind = ((Referenceable)objToBind).getReference();
            }
            __root.removeBinding(cname);
            __root.addBinding(cname, objToBind);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking for existing binding for name=" + cname + " for first element of name=" + cname.get(0), new Object[0]);
            }
            this.getContext(cname).rebind(cname.getSuffix(1), obj);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(__root.getNameParser("").parse(this.getSuffix(name)), obj);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(__root.getNameParser("").parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (__root.isLocked()) {
            NamingException ne = new NamingException("This context is immutable");
            ne.setRemainingName(name);
            throw ne;
        }
        Name cname = __root.toCanonicalName(name);
        if (cname == null) {
            throw new NamingException("Name is null");
        }
        if (cname.size() == 0) {
            throw new NamingException("Name is empty");
        }
        if (cname.size() == 1) {
            Binding binding = __root.getBinding(cname);
            if (binding != null) {
                throw new NameAlreadyBoundException(cname.toString());
            }
            NamingContext ctx = new NamingContext(this._env, cname.get(0), __root, __root.getNameParser(""));
            __root.addBinding(cname, ctx);
            return ctx;
        }
        return this.getContext(cname).createSubcontext(cname.getSuffix(1));
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return __root.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return __root.getNameParser(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return __root.list(name);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return __root.list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return __root.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return __root.listBindings(name);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this._env.put(propName, propVal);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return __root.composeName(name, prefix);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return __root.composeName(name, prefix);
    }

    protected String getSuffix(String url) throws NamingException {
        return url;
    }

    protected Name getSuffix(Name name) throws NamingException {
        return name;
    }

    static class LocalNameParser
    implements NameParser {
        Properties syntax = new Properties();

        LocalNameParser() {
            this.syntax.put("jndi.syntax.direction", "left_to_right");
            this.syntax.put("jndi.syntax.separator", "/");
            this.syntax.put("jndi.syntax.ignorecase", "false");
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, this.syntax);
        }
    }

    static class NamingRoot
    extends NamingContext {
        public NamingRoot() {
            super(null, null, null, new LocalNameParser());
        }
    }
}

