/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hdfs;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.hdfs.NameNodeServiceModelGenerator;

public class HdfsUIServiceModelGenerator
extends NameNodeServiceModelGenerator {
    public static final String SERVICE = "HDFSUI";
    static final String SSL_ENABLED = "hdfs_hadoop_ssl_enabled";
    static final String HTTP_PORT = "dfs_http_port";
    static final String HTTPS_PORT = "dfs_https_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        }
        String namenodeUrl = String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port);
        ServiceModel model = this.createServiceModel(namenodeUrl);
        model.addServiceProperty(SSL_ENABLED, this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        model.addRoleProperty(role.getType(), HTTPS_PORT, this.getRoleConfigValue(roleConfig, HTTPS_PORT));
        model.addRoleProperty(role.getType(), HTTP_PORT, this.getRoleConfigValue(roleConfig, HTTP_PORT));
        return model;
    }
}

