/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.impala;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class ImpalaServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "IMPALA";
    public static final String SERVICE_TYPE = "IMPALA";
    public static final String ROLE_TYPE = "IMPALAD";
    static final String SSL_ENABLED = "client_services_ssl_enabled";
    static final String HTTP_PORT = "hs2_http_port";

    @Override
    public String getService() {
        return "IMPALA";
    }

    @Override
    public String getServiceType() {
        return "IMPALA";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        String port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s/", scheme, hostname, port));
        model.addServiceProperty(SSL_ENABLED, this.getServiceConfigValue(serviceConfig, SSL_ENABLED));
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, port);
        return model;
    }
}

