/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.generator;

import org.pac4j.core.authorization.generator.AuthorizationGenerator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.service.ProfileService;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;

public class LoadLinkedUserAuthorizationGenerator<U extends CommonProfile>
extends InitializableObject
implements AuthorizationGenerator<U> {
    private ProfileService<U> profileService;
    private boolean failIfLinkedUserNotFound = true;

    public LoadLinkedUserAuthorizationGenerator() {
    }

    public LoadLinkedUserAuthorizationGenerator(ProfileService<U> profileService) {
        this.profileService = profileService;
    }

    @Override
    protected void internalInit() {
        CommonHelper.assertNotNull("profileService", this.profileService);
    }

    @Override
    public U generate(WebContext context, U profile) {
        this.init();
        U linkedProfile = this.profileService.findByLinkedId(((UserProfile)profile).getId());
        if (linkedProfile != null) {
            return linkedProfile;
        }
        if (this.failIfLinkedUserNotFound) {
            throw new TechnicalException("No linked account found for: " + profile);
        }
        return profile;
    }

    public ProfileService<U> getProfileService() {
        return this.profileService;
    }

    public void setProfileService(ProfileService<U> profileService) {
        this.profileService = profileService;
    }

    public boolean isFailIfLinkedUserNotFound() {
        return this.failIfLinkedUserNotFound;
    }

    public void setFailIfLinkedUserNotFound(boolean failIfLinkedUserNotFound) {
        this.failIfLinkedUserNotFound = failIfLinkedUserNotFound;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "profileService", this.profileService, "failIfLinkedUserNotFound", this.failIfLinkedUserNotFound);
    }
}

