/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.apache.knox.gateway.launcher.Command;

public class Launcher {
    private static final String LAUNCHER_PREFIX = "launcher.";
    private static final String CFG_EXT = "cfg";
    private static final String LAUNCHER_CFG = "META-INF/launcher.cfg";
    private static final String EXTRACT = "extract";
    private static final String OVERRIDE = "override";
    private URL launcherJarUrl;
    private File launcherJarDir;
    private String launcherName;
    private URL embeddedConfigUrl;
    private URL externalConfigUrl;
    private Command command;
    private Boolean extract = Boolean.TRUE;
    private Boolean override = Boolean.TRUE;

    public static void main(String[] args) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, IOException {
        Launcher launcher = new Launcher(args);
        launcher.run();
    }

    Launcher(String[] args) throws IOException {
        this.launcherJarUrl = Launcher.findLauncherJar();
        this.launcherJarDir = Launcher.calcLauncherDir(this.launcherJarUrl);
        this.launcherName = Launcher.calcLauncherName(this.launcherJarUrl);
        this.embeddedConfigUrl = Launcher.findEmbeddedConfig();
        Properties properties = new Properties();
        Launcher.loadProperties(properties, this.embeddedConfigUrl);
        this.consumeLauncherConfig(properties);
        if (this.override.booleanValue()) {
            this.externalConfigUrl = Launcher.findOrCreateExternalConfig(this.launcherJarDir, this.launcherName, properties, this.embeddedConfigUrl, this.extract);
            if (this.externalConfigUrl != null) {
                Launcher.loadProperties(properties, this.externalConfigUrl);
            }
        }
        properties.setProperty("launcher.dir", this.launcherJarDir.getAbsolutePath());
        properties.setProperty("launcher.name", this.launcherName);
        this.command = new Command(this.launcherJarDir, properties, args);
    }

    void run() throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        this.command.run();
    }

    private static URL findLauncherJar() {
        return Launcher.class.getProtectionDomain().getCodeSource().getLocation();
    }

    static String calcLauncherName(URL launcherJarUrl) {
        String name = launcherJarUrl.getPath();
        name = Launcher.fileName(name);
        name = Launcher.baseName(name);
        return name;
    }

    void consumeLauncherConfig(Properties properties) {
        this.extract = Boolean.valueOf(properties.getProperty(EXTRACT, this.extract.toString()));
        properties.remove(EXTRACT);
        this.override = Boolean.valueOf(properties.getProperty(OVERRIDE, this.override.toString()));
        properties.remove(OVERRIDE);
    }

    private static File calcLauncherDir(URL libUrl) throws UnsupportedEncodingException {
        String libPath = URLDecoder.decode(libUrl.getFile(), StandardCharsets.UTF_8.name());
        File libFile = new File(libPath);
        File dir = libFile.isDirectory() ? libFile : libFile.getParentFile();
        return dir;
    }

    private static URL findEmbeddedConfig() {
        return ClassLoader.getSystemResource(LAUNCHER_CFG);
    }

    private static void createExternalConfig(File file, Properties config, URL src) throws IOException {
        block8: {
            try {
                if (!file.createNewFile()) break block8;
                try (OutputStream output = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                    config.store(output, "Created from " + src);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static URL findOrCreateExternalConfig(File launcherJarDir, String launcherName, Properties embeddedConfig, URL embeddedConfigUrl, boolean extract) throws IOException {
        File externalConfigFile = new File(launcherJarDir, launcherName + "." + CFG_EXT);
        if (!externalConfigFile.exists() && extract) {
            Launcher.createExternalConfig(externalConfigFile, embeddedConfig, embeddedConfigUrl);
        }
        URL externalConfigUrl = null;
        if (externalConfigFile.isFile() && externalConfigFile.canRead()) {
            externalConfigUrl = externalConfigFile.toURI().toURL();
        }
        return externalConfigUrl;
    }

    private static Properties loadProperties(Properties properties, URL url) throws IOException {
        if (url != null) {
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
        }
        return properties;
    }

    static String fileName(String fullName) {
        int i = fullName.lastIndexOf(47);
        if (i < 0) {
            i = fullName.lastIndexOf(92);
        }
        return i < 0 ? fullName : fullName.substring(i + 1);
    }

    static String baseName(String fullName) {
        int i = fullName.lastIndexOf(46);
        return i < 0 ? fullName : fullName.substring(0, i);
    }
}

