/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.HashMap;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.CryptoService;
import org.apache.knox.gateway.services.security.EncryptionResult;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.impl.ConfigurableEncryptor;

public class DefaultCryptoService
implements CryptoService {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final Map<String, ConfigurableEncryptor> ENCRYPTOR_CACHE = new HashMap<String, ConfigurableEncryptor>();
    private AliasService as;
    private KeystoreService ks;
    private GatewayConfig config;

    public void setKeystoreService(KeystoreService ks) {
        this.ks = ks;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        if (this.as == null) {
            throw new ServiceLifecycleException("Alias service is not set");
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public void createAndStoreEncryptionKeyForCluster(String clusterName, String alias) {
        try {
            this.as.generateAliasForCluster(clusterName, alias);
        }
        catch (AliasServiceException e) {
            e.printStackTrace();
        }
    }

    public EncryptionResult encryptForCluster(String clusterName, String alias, byte[] clear) {
        char[] password = null;
        try {
            password = this.as.getPasswordFromAliasForCluster(clusterName, alias);
        }
        catch (AliasServiceException e2) {
            e2.printStackTrace();
        }
        if (password != null) {
            try {
                return this.getEncryptor(clusterName, password).encrypt(clear);
            }
            catch (Exception e) {
                LOG.failedToEncryptPasswordForCluster(clusterName, e);
            }
        }
        return null;
    }

    public byte[] decryptForCluster(String clusterName, String alias, String cipherText) {
        return this.decryptForCluster(clusterName, alias, cipherText.getBytes(StandardCharsets.UTF_8), null, null);
    }

    public byte[] decryptForCluster(String clusterName, String alias, byte[] cipherText, byte[] iv, byte[] salt) {
        try {
            char[] password = this.as.getPasswordFromAliasForCluster(clusterName, alias);
            if (password != null) {
                ConfigurableEncryptor encryptor = this.getEncryptor(clusterName, password);
                try {
                    return encryptor.decrypt(salt, iv, cipherText);
                }
                catch (Exception e) {
                    LOG.failedToDecryptPasswordForCluster(clusterName, e);
                }
            } else {
                LOG.failedToDecryptCipherForClusterNullPassword(clusterName);
            }
        }
        catch (AliasServiceException e1) {
            LOG.failedToDecryptCipherForClusterNullPassword(clusterName);
        }
        return null;
    }

    public boolean verify(String algorithm, String signed, byte[] signature) {
        boolean verified = false;
        try {
            Signature sig = Signature.getInstance(algorithm);
            sig.initVerify(this.ks.getCertificateForGateway().getPublicKey());
            sig.update(signed.getBytes(StandardCharsets.UTF_8));
            verified = sig.verify(signature);
        }
        catch (InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | SignatureException | KeystoreServiceException e) {
            LOG.failedToVerifySignature((Exception)e);
        }
        LOG.signatureVerified(verified);
        return verified;
    }

    public byte[] sign(String algorithm, String payloadToSign) {
        try {
            char[] passphrase = this.as.getGatewayIdentityPassphrase();
            PrivateKey privateKey = (PrivateKey)this.ks.getKeyForGateway(passphrase);
            Signature signature = Signature.getInstance(algorithm);
            signature.initSign(privateKey);
            signature.update(payloadToSign.getBytes(StandardCharsets.UTF_8));
            return signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | AliasServiceException | KeystoreServiceException e) {
            LOG.failedToSignData((Exception)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurableEncryptor getEncryptor(String clusterName, char[] password) {
        Map<String, ConfigurableEncryptor> map = ENCRYPTOR_CACHE;
        synchronized (map) {
            ConfigurableEncryptor encryptor = ENCRYPTOR_CACHE.get(clusterName);
            if (encryptor == null) {
                encryptor = new ConfigurableEncryptor(String.valueOf(password));
                encryptor.init(this.config);
                ENCRYPTOR_CACHE.put(clusterName, encryptor);
            }
            return encryptor;
        }
    }
}

