/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariComponent;
import org.apache.knox.gateway.topology.discovery.ambari.SparkCommonServiceURLCreator;

public class LivyServiceURLCreator
extends SparkCommonServiceURLCreator {
    private static final String RESOURCE_ROLE = "LIVYSERVER";

    @Override
    public void init(AmbariCluster cluster) {
        super.init(cluster);
        this.primaryComponentName = "LIVY_SERVER";
        this.secondaryComponentName = "LIVY2_SERVER";
        this.portConfigProperty = "livy.server.port";
    }

    @Override
    public String getTargetService() {
        return RESOURCE_ROLE;
    }

    @Override
    boolean isSSL(AmbariComponent comp) {
        String keystore = comp.getConfigProperty("livy.keystore");
        return keystore != null && !keystore.isEmpty();
    }
}

