/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.preauth.pkinit;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.AuthPack;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.KdcDhKeyInfo;
import org.apache.kerby.kerberos.kerb.type.pa.pkinit.ReplyKeyPack;
import org.apache.kerby.pkix.PkiException;
import org.apache.kerby.pkix.PkiUtil;

public class PkinitUtil {
    private static final String ID_PKINIT_AUTHDATA = "1.3.6.1.5.2.3.1";

    public static byte[] getSignedAuthPack(PrivateKey privateKey, X509Certificate certificate, AuthPack authPack) throws KrbException {
        byte[] signedData;
        byte[] dataToSign = KrbCodec.encode((Asn1Type)authPack);
        try {
            signedData = PkiUtil.getSignedData((PrivateKey)privateKey, (X509Certificate)certificate, (byte[])dataToSign, (String)ID_PKINIT_AUTHDATA);
        }
        catch (PkiException e) {
            throw new KrbException("Failed to sign data", (Throwable)e);
        }
        return signedData;
    }

    public static byte[] getSignedKdcDhKeyInfo(PrivateKey privateKey, X509Certificate certificate, KdcDhKeyInfo kdcDhKeyInfo) throws KrbException {
        byte[] signedData;
        byte[] dataToSign = KrbCodec.encode((Asn1Type)kdcDhKeyInfo);
        try {
            signedData = PkiUtil.getSignedData((PrivateKey)privateKey, (X509Certificate)certificate, (byte[])dataToSign, (String)ID_PKINIT_AUTHDATA);
        }
        catch (PkiException e) {
            throw new KrbException("Failed to sign data", (Throwable)e);
        }
        return signedData;
    }

    public static byte[] getSignedReplyKeyPack(PrivateKey privateKey, X509Certificate certificate, ReplyKeyPack replyKeyPack) throws KrbException {
        byte[] signedData;
        byte[] dataToSign = KrbCodec.encode((Asn1Type)replyKeyPack);
        try {
            signedData = PkiUtil.getSignedData((PrivateKey)privateKey, (X509Certificate)certificate, (byte[])dataToSign, (String)ID_PKINIT_AUTHDATA);
        }
        catch (PkiException e) {
            throw new KrbException("Failed to sign data", (Throwable)e);
        }
        return signedData;
    }
}

